@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The NetworkFabricController resource definition.
 * @property annotation Switch configuration description.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property infrastructureExpressRouteConnections As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
 * @property infrastructureServices InfrastructureServices IP ranges.
 * @property ipv4AddressSpace IPv4 Network Fabric Controller Address Space.
 * @property ipv6AddressSpace IPv6 Network Fabric Controller Address Space.
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration Managed Resource Group configuration properties.
 * @property name The name of the resource
 * @property networkFabricIds The NF-ID will be an input parameter used by the NF to link and get associated with the parent NFC Service.
 * @property operationalState The Operational Status would always be NULL. Look only in to the Provisioning state for the latest status.
 * @property provisioningState Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on the status of NFC provisioning.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property workloadExpressRouteConnections As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
 * @property workloadManagementNetwork A workload management network is required for all the tenant (workload) traffic. This traffic is only dedicated for Tenant workloads which are required to access internet or any other MSFT/Public endpoints.
 * @property workloadServices WorkloadServices IP ranges.
 */
public data class GetNetworkFabricControllerResult(
    public val `annotation`: String? = null,
    public val id: String,
    public val infrastructureExpressRouteConnections: List<ExpressRouteConnectionInformationResponse>? =
        null,
    public val infrastructureServices: InfrastructureServicesResponse,
    public val ipv4AddressSpace: String? = null,
    public val ipv6AddressSpace: String? = null,
    public val location: String,
    public val managedResourceGroupConfiguration: ManagedResourceGroupConfigurationResponse? = null,
    public val name: String,
    public val networkFabricIds: List<String>,
    public val operationalState: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val workloadExpressRouteConnections: List<ExpressRouteConnectionInformationResponse>? =
        null,
    public val workloadManagementNetwork: Boolean,
    public val workloadServices: WorkloadServicesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkFabricControllerResult):
            GetNetworkFabricControllerResult = GetNetworkFabricControllerResult(
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            infrastructureExpressRouteConnections = javaType.infrastructureExpressRouteConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ExpressRouteConnectionInformationResponse.Companion.toKotlin(args0)
                })
            }),
            infrastructureServices = javaType.infrastructureServices().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.InfrastructureServicesResponse.Companion.toKotlin(args0)
            }),
            ipv4AddressSpace = javaType.ipv4AddressSpace().map({ args0 -> args0 }).orElse(null),
            ipv6AddressSpace = javaType.ipv6AddressSpace().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ManagedResourceGroupConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkFabricIds = javaType.networkFabricIds().map({ args0 -> args0 }),
            operationalState = javaType.operationalState(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            workloadExpressRouteConnections = javaType.workloadExpressRouteConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ExpressRouteConnectionInformationResponse.Companion.toKotlin(args0)
                })
            }),
            workloadManagementNetwork = javaType.workloadManagementNetwork(),
            workloadServices = javaType.workloadServices().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.WorkloadServicesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
