@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the NetworkInterface resource.
 * @property administrativeState administrativeState of the network interface. Example: Enabled | Disabled.
 * @property annotation Switch configuration description.
 * @property connectedTo The arm resource id of the interface or compute server its connected to.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property interfaceType The Interface Type. Example: Management/Data
 * @property ipv4Address ipv4Address.
 * @property ipv6Address ipv6Address.
 * @property name The name of the resource
 * @property physicalIdentifier physicalIdentifier of the network interface.
 * @property provisioningState Gets the provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNetworkInterfaceResult(
    public val administrativeState: String,
    public val `annotation`: String? = null,
    public val connectedTo: String,
    public val id: String,
    public val interfaceType: String,
    public val ipv4Address: String,
    public val ipv6Address: String,
    public val name: String,
    public val physicalIdentifier: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkInterfaceResult):
            GetNetworkInterfaceResult = GetNetworkInterfaceResult(
            administrativeState = javaType.administrativeState(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            connectedTo = javaType.connectedTo(),
            id = javaType.id(),
            interfaceType = javaType.interfaceType(),
            ipv4Address = javaType.ipv4Address(),
            ipv6Address = javaType.ipv6Address(),
            name = javaType.name(),
            physicalIdentifier = javaType.physicalIdentifier(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
