@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connected Subnet RoutePolicy
 * @property administrativeState Enabled/Disabled connected subnet route policy. Ex: Enabled | Disabled.
 * @property exportRoutePolicyId exportRoutePolicyId value.
 */
public data class L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy(
    public val administrativeState: String,
    public val exportRoutePolicyId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy):
            L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy =
            L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy(
                administrativeState = javaType.administrativeState(),
                exportRoutePolicyId = javaType.exportRoutePolicyId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
