@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Option B configuration.
 * @property exportRouteTargets Route Targets to be applied for outgoing routes from CE.
 * @property importRouteTargets Route Targets to be applied for incoming routes into CE.
 */
public data class OptionBPropertiesResponse(
    public val exportRouteTargets: List<String>? = null,
    public val importRouteTargets: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.OptionBPropertiesResponse):
            OptionBPropertiesResponse = OptionBPropertiesResponse(
            exportRouteTargets = javaType.exportRouteTargets().map({ args0 -> args0 }),
            importRouteTargets = javaType.importRouteTargets().map({ args0 -> args0 }),
        )
    }
}
