@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Vlan group properties.
 * @property name Vlan group name.
 * @property vlans List of vlans.
 */
public data class VlanGroupPropertiesResponse(
    public val name: String? = null,
    public val vlans: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.VlanGroupPropertiesResponse):
            VlanGroupPropertiesResponse = VlanGroupPropertiesResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            vlans = javaType.vlans().map({ args0 -> args0 }),
        )
    }
}
