@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin

import com.pulumi.azurenative.managedservices.RegistrationAssignmentArgs.builder
import com.pulumi.azurenative.managedservices.kotlin.inputs.RegistrationAssignmentPropertiesArgs
import com.pulumi.azurenative.managedservices.kotlin.inputs.RegistrationAssignmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The registration assignment.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * ## Example Usage
 * ### Put Registration Assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registrationAssignment = new AzureNative.ManagedServices.RegistrationAssignment("registrationAssignment", new()
 *     {
 *         Properties = new AzureNative.ManagedServices.Inputs.RegistrationAssignmentPropertiesArgs
 *         {
 *             RegistrationDefinitionId = "/subscriptions/0afefe50-734e-4610-8a82-a144ahf49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-6e081c90ada2",
 *         },
 *         RegistrationAssignmentId = "26c128c2-fefa-4340-9bb1-6e081c90ada2",
 *         Scope = "subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managedservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managedservices.NewRegistrationAssignment(ctx, "registrationAssignment", &managedservices.RegistrationAssignmentArgs{
 * 			Properties: &managedservices.RegistrationAssignmentPropertiesArgs{
 * 				RegistrationDefinitionId: pulumi.String("/subscriptions/0afefe50-734e-4610-8a82-a144ahf49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-6e081c90ada2"),
 * 			},
 * 			RegistrationAssignmentId: pulumi.String("26c128c2-fefa-4340-9bb1-6e081c90ada2"),
 * 			Scope:                    pulumi.String("subscription/0afefe50-734e-4610-8a82-a144ahf49dea"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managedservices.RegistrationAssignment;
 * import com.pulumi.azurenative.managedservices.RegistrationAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registrationAssignment = new RegistrationAssignment("registrationAssignment", RegistrationAssignmentArgs.builder()
 *             .properties(Map.of("registrationDefinitionId", "/subscriptions/0afefe50-734e-4610-8a82-a144ahf49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-6e081c90ada2"))
 *             .registrationAssignmentId("26c128c2-fefa-4340-9bb1-6e081c90ada2")
 *             .scope("subscription/0afefe50-734e-4610-8a82-a144ahf49dea")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managedservices:RegistrationAssignment 484a7d5f-9729-4b87-bc9b-26610985a013 /{scope}/providers/Microsoft.ManagedServices/registrationAssignments/{registrationAssignmentId}
 * ```
 * @property properties The properties of a registration assignment.
 * @property registrationAssignmentId The GUID of the registration assignment.
 * @property scope The scope of the resource.
 */
public data class RegistrationAssignmentArgs(
    public val properties: Output<RegistrationAssignmentPropertiesArgs>? = null,
    public val registrationAssignmentId: Output<String>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managedservices.RegistrationAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.managedservices.RegistrationAssignmentArgs =
        com.pulumi.azurenative.managedservices.RegistrationAssignmentArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registrationAssignmentId(registrationAssignmentId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistrationAssignmentArgs].
 */
@PulumiTagMarker
public class RegistrationAssignmentArgsBuilder internal constructor() {
    private var properties: Output<RegistrationAssignmentPropertiesArgs>? = null

    private var registrationAssignmentId: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The properties of a registration assignment.
     */
    @JvmName("lwbkumkdejvjkmmq")
    public suspend fun properties(`value`: Output<RegistrationAssignmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The GUID of the registration assignment.
     */
    @JvmName("smwvlsupirxhporr")
    public suspend fun registrationAssignmentId(`value`: Output<String>) {
        this.registrationAssignmentId = value
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("sdoioxiybyffxbat")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The properties of a registration assignment.
     */
    @JvmName("qpiqeuduqqtrdejs")
    public suspend fun properties(`value`: RegistrationAssignmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of a registration assignment.
     */
    @JvmName("fyaqvswnntpujldk")
    public suspend
    fun properties(argument: suspend RegistrationAssignmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RegistrationAssignmentPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The GUID of the registration assignment.
     */
    @JvmName("dthddfmuuryuvdbh")
    public suspend fun registrationAssignmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationAssignmentId = mapped
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("vfascrghkdpuctle")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): RegistrationAssignmentArgs = RegistrationAssignmentArgs(
        properties = properties,
        registrationAssignmentId = registrationAssignmentId,
        scope = scope,
    )
}
