@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.RegistrationDefinitionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a registration definition.
 * @property authorizations The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
 * @property description The description of the registration definition.
 * @property eligibleAuthorizations The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
 * @property managedByTenantId The identifier of the managedBy tenant.
 * @property registrationDefinitionName The name of the registration definition.
 */
public data class RegistrationDefinitionPropertiesArgs(
    public val authorizations: Output<List<AuthorizationArgs>>,
    public val description: Output<String>? = null,
    public val eligibleAuthorizations: Output<List<EligibleAuthorizationArgs>>? = null,
    public val managedByTenantId: Output<String>,
    public val registrationDefinitionName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.RegistrationDefinitionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managedservices.inputs.RegistrationDefinitionPropertiesArgs =
        com.pulumi.azurenative.managedservices.inputs.RegistrationDefinitionPropertiesArgs.builder()
            .authorizations(
                authorizations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .eligibleAuthorizations(
                eligibleAuthorizations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .managedByTenantId(managedByTenantId.applyValue({ args0 -> args0 }))
            .registrationDefinitionName(registrationDefinitionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistrationDefinitionPropertiesArgs].
 */
@PulumiTagMarker
public class RegistrationDefinitionPropertiesArgsBuilder internal constructor() {
    private var authorizations: Output<List<AuthorizationArgs>>? = null

    private var description: Output<String>? = null

    private var eligibleAuthorizations: Output<List<EligibleAuthorizationArgs>>? = null

    private var managedByTenantId: Output<String>? = null

    private var registrationDefinitionName: Output<String>? = null

    /**
     * @param value The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("yelhcadqtrifqjxy")
    public suspend fun authorizations(`value`: Output<List<AuthorizationArgs>>) {
        this.authorizations = value
    }

    @JvmName("xiducyuadokbxqjt")
    public suspend fun authorizations(vararg values: Output<AuthorizationArgs>) {
        this.authorizations = Output.all(values.asList())
    }

    /**
     * @param values The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("ljfcxxkyaiaingkt")
    public suspend fun authorizations(values: List<Output<AuthorizationArgs>>) {
        this.authorizations = Output.all(values)
    }

    /**
     * @param value The description of the registration definition.
     */
    @JvmName("uevqxhcrxcdtnpsl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("lynlvqwrurawlocf")
    public suspend fun eligibleAuthorizations(`value`: Output<List<EligibleAuthorizationArgs>>) {
        this.eligibleAuthorizations = value
    }

    @JvmName("cukbmrnapxkjbcgi")
    public suspend fun eligibleAuthorizations(vararg values: Output<EligibleAuthorizationArgs>) {
        this.eligibleAuthorizations = Output.all(values.asList())
    }

    /**
     * @param values The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("ieuecluikvevnbao")
    public suspend fun eligibleAuthorizations(values: List<Output<EligibleAuthorizationArgs>>) {
        this.eligibleAuthorizations = Output.all(values)
    }

    /**
     * @param value The identifier of the managedBy tenant.
     */
    @JvmName("rgrxypsickstguyw")
    public suspend fun managedByTenantId(`value`: Output<String>) {
        this.managedByTenantId = value
    }

    /**
     * @param value The name of the registration definition.
     */
    @JvmName("qfrtudbuvyvrsauk")
    public suspend fun registrationDefinitionName(`value`: Output<String>) {
        this.registrationDefinitionName = value
    }

    /**
     * @param value The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("lcpkcdevbgeqskuh")
    public suspend fun authorizations(`value`: List<AuthorizationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param argument The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("iqbfqmmvkkalbhja")
    public suspend fun authorizations(argument: List<suspend AuthorizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("adeqgyjedlbomwno")
    public suspend fun authorizations(vararg argument: suspend AuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("lhgqwmkcgenyapxf")
    public suspend fun authorizations(argument: suspend AuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AuthorizationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param values The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("cweeqjtsoaqtmdih")
    public suspend fun authorizations(vararg values: AuthorizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param value The description of the registration definition.
     */
    @JvmName("wpawnixxrgrmmcne")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("rikrkuwtgwvwrqoc")
    public suspend fun eligibleAuthorizations(`value`: List<EligibleAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eligibleAuthorizations = mapped
    }

    /**
     * @param argument The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("ajnglrdqptgxltqn")
    public suspend
    fun eligibleAuthorizations(argument: List<suspend EligibleAuthorizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EligibleAuthorizationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eligibleAuthorizations = mapped
    }

    /**
     * @param argument The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("rvgptexypsjrpomk")
    public suspend fun eligibleAuthorizations(
        vararg
        argument: suspend EligibleAuthorizationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EligibleAuthorizationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eligibleAuthorizations = mapped
    }

    /**
     * @param argument The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("xfbteqfnnmwnknat")
    public suspend
    fun eligibleAuthorizations(argument: suspend EligibleAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EligibleAuthorizationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eligibleAuthorizations = mapped
    }

    /**
     * @param values The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
     */
    @JvmName("ngiaayoeccvqycme")
    public suspend fun eligibleAuthorizations(vararg values: EligibleAuthorizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eligibleAuthorizations = mapped
    }

    /**
     * @param value The identifier of the managedBy tenant.
     */
    @JvmName("ipjtkixoepoigueg")
    public suspend fun managedByTenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedByTenantId = mapped
    }

    /**
     * @param value The name of the registration definition.
     */
    @JvmName("yfcnawidiinuwqdy")
    public suspend fun registrationDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationDefinitionName = mapped
    }

    internal fun build(): RegistrationDefinitionPropertiesArgs = RegistrationDefinitionPropertiesArgs(
        authorizations = authorizations ?: throw PulumiNullFieldException("authorizations"),
        description = description,
        eligibleAuthorizations = eligibleAuthorizations,
        managedByTenantId = managedByTenantId ?: throw PulumiNullFieldException("managedByTenantId"),
        registrationDefinitionName = registrationDefinitionName,
    )
}
