@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the Azure Active Directory principal that can approve any just-in-time access requests by the principal defined in the EligibleAuthorization.
 * @property principalId The identifier of the Azure Active Directory principal.
 * @property principalIdDisplayName The display name of the Azure Active Directory principal.
 */
public data class EligibleApproverResponse(
    public val principalId: String,
    public val principalIdDisplayName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.EligibleApproverResponse):
            EligibleApproverResponse = EligibleApproverResponse(
            principalId = javaType.principalId(),
            principalIdDisplayName = javaType.principalIdDisplayName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
