@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The registration assignment.
 * @property id The fully qualified path of the registration assignment.
 * @property name The name of the registration assignment.
 * @property properties The properties of a registration assignment.
 * @property systemData The metadata for the registration assignment resource.
 * @property type The type of the Azure resource (Microsoft.ManagedServices/registrationAssignments).
 */
public data class GetRegistrationAssignmentResult(
    public val id: String,
    public val name: String,
    public val properties: RegistrationAssignmentPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.GetRegistrationAssignmentResult):
            GetRegistrationAssignmentResult = GetRegistrationAssignmentResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.managedservices.kotlin.outputs.RegistrationAssignmentPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managedservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
