@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The registration definition.
 * @property id The fully qualified path of the registration definition.
 * @property name The name of the registration definition.
 * @property plan The details for the Managed Services offer’s plan in Azure Marketplace.
 * @property properties The properties of a registration definition.
 * @property systemData The metadata for the registration assignment resource.
 * @property type The type of the Azure resource (Microsoft.ManagedServices/registrationDefinitions).
 */
public data class GetRegistrationDefinitionResult(
    public val id: String,
    public val name: String,
    public val plan: PlanResponse? = null,
    public val properties: RegistrationDefinitionPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.GetRegistrationDefinitionResult):
            GetRegistrationDefinitionResult = GetRegistrationDefinitionResult(
            id = javaType.id(),
            name = javaType.name(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managedservices.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.managedservices.kotlin.outputs.RegistrationDefinitionPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managedservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
