@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin

import com.pulumi.azurenative.management.ManagementFunctions.getEntityPlain
import com.pulumi.azurenative.management.ManagementFunctions.getHierarchySettingPlain
import com.pulumi.azurenative.management.ManagementFunctions.getManagementGroupPlain
import com.pulumi.azurenative.management.ManagementFunctions.getManagementGroupSubscriptionPlain
import com.pulumi.azurenative.management.kotlin.inputs.GetEntityPlainArgs
import com.pulumi.azurenative.management.kotlin.inputs.GetEntityPlainArgsBuilder
import com.pulumi.azurenative.management.kotlin.inputs.GetHierarchySettingPlainArgs
import com.pulumi.azurenative.management.kotlin.inputs.GetHierarchySettingPlainArgsBuilder
import com.pulumi.azurenative.management.kotlin.inputs.GetManagementGroupPlainArgs
import com.pulumi.azurenative.management.kotlin.inputs.GetManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.management.kotlin.inputs.GetManagementGroupSubscriptionPlainArgs
import com.pulumi.azurenative.management.kotlin.inputs.GetManagementGroupSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.management.kotlin.outputs.GetEntityResult
import com.pulumi.azurenative.management.kotlin.outputs.GetHierarchySettingResult
import com.pulumi.azurenative.management.kotlin.outputs.GetManagementGroupResult
import com.pulumi.azurenative.management.kotlin.outputs.GetManagementGroupSubscriptionResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.management.kotlin.outputs.GetEntityResult.Companion.toKotlin as getEntityResultToKotlin
import com.pulumi.azurenative.management.kotlin.outputs.GetHierarchySettingResult.Companion.toKotlin as getHierarchySettingResultToKotlin
import com.pulumi.azurenative.management.kotlin.outputs.GetManagementGroupResult.Companion.toKotlin as getManagementGroupResultToKotlin
import com.pulumi.azurenative.management.kotlin.outputs.GetManagementGroupSubscriptionResult.Companion.toKotlin as getManagementGroupSubscriptionResultToKotlin

public object ManagementFunctions {
    /**
     * List all entities (Management Groups, Subscriptions, etc.) for the authenticated user.
     * Azure REST API version: 2021-04-01.
     * Other available API versions: 2018-01-01-preview, 2018-03-01-preview, 2019-11-01, 2020-02-01, 2020-05-01, 2020-10-01, 2023-04-01.
     * @param argument null
     * @return Describes the result of the request to view entities.
     */
    public suspend fun getEntity(argument: GetEntityPlainArgs): GetEntityResult =
        getEntityResultToKotlin(getEntityPlain(argument.toJava()).await())

    /**
     * @see [getEntity].
     * @param filter The filter parameter allows you to filter on the the name or display name fields. You can check for equality on the name field (e.g. name eq '{entityName}')  and you can check for substrings on either the name or display name fields(e.g. contains(name, '{substringToSearch}'), contains(displayName, '{substringToSearch')). Note that the '{entityName}' and '{substringToSearch}' fields are checked case insensitively.
     * @param groupName A filter which allows the get entities call to focus on a particular group (i.e. "$filter=name eq 'groupName'")
     * @param search The $search parameter is used in conjunction with the $filter parameter to return three different outputs depending on the parameter passed in.
     * With $search=AllowedParents the API will return the entity info of all groups that the requested entity will be able to reparent to as determined by the user's permissions.
     * With $search=AllowedChildren the API will return the entity info of all entities that can be added as children of the requested entity.
     * With $search=ParentAndFirstLevelChildren the API will return the parent and  first level of children that the user has either direct access to or indirect access via one of their descendants.
     * With $search=ParentOnly the API will return only the group if the user has access to at least one of the descendants of the group.
     * With $search=ChildrenOnly the API will return only the first level of children of the group entity info specified in $filter.  The user must have direct access to the children entities or one of it's descendants for it to show up in the results.
     * @param select This parameter specifies the fields to include in the response. Can include any combination of Name,DisplayName,Type,ParentDisplayNameChain,ParentChain, e.g. '$select=Name,DisplayName,Type,ParentDisplayNameChain,ParentNameChain'. When specified the $select parameter can override select in $skipToken.
     * @param skip Number of entities to skip over when retrieving results. Passing this in will override $skipToken.
     * @param skiptoken Page continuation token is only used if a previous operation returned a partial result.
     * If a previous response contains a nextLink element, the value of the nextLink element will include a token parameter that specifies a starting point to use for subsequent calls.
     * @param top Number of elements to return when retrieving results. Passing this in will override $skipToken.
     * @param view The view parameter allows clients to filter the type of data that is returned by the getEntities call.
     * @return Describes the result of the request to view entities.
     */
    public suspend fun getEntity(
        filter: String? = null,
        groupName: String? = null,
        search: String? = null,
        select: String? = null,
        skip: Int? = null,
        skiptoken: String? = null,
        top: Int? = null,
        view: String? = null,
    ): GetEntityResult {
        val argument = GetEntityPlainArgs(
            filter = filter,
            groupName = groupName,
            search = search,
            select = select,
            skip = skip,
            skiptoken = skiptoken,
            top = top,
            view = view,
        )
        return getEntityResultToKotlin(getEntityPlain(argument.toJava()).await())
    }

    /**
     * @see [getEntity].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;management&#46;kotlin&#46;inputs&#46;GetEntityPlainArgs].
     * @return Describes the result of the request to view entities.
     */
    public suspend fun getEntity(argument: suspend GetEntityPlainArgsBuilder.() -> Unit):
        GetEntityResult {
        val builder = GetEntityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEntityResultToKotlin(getEntityPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the hierarchy settings defined at the Management Group level. Settings can only be set on the root Management Group of the hierarchy.
     * Azure REST API version: 2021-04-01.
     * Other available API versions: 2023-04-01.
     * @param argument null
     * @return Settings defined at the Management Group scope.
     */
    public suspend fun getHierarchySetting(argument: GetHierarchySettingPlainArgs):
        GetHierarchySettingResult =
        getHierarchySettingResultToKotlin(getHierarchySettingPlain(argument.toJava()).await())

    /**
     * @see [getHierarchySetting].
     * @param groupId Management Group ID.
     * @return Settings defined at the Management Group scope.
     */
    public suspend fun getHierarchySetting(groupId: String): GetHierarchySettingResult {
        val argument = GetHierarchySettingPlainArgs(
            groupId = groupId,
        )
        return getHierarchySettingResultToKotlin(getHierarchySettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getHierarchySetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;management&#46;kotlin&#46;inputs&#46;GetHierarchySettingPlainArgs].
     * @return Settings defined at the Management Group scope.
     */
    public suspend
    fun getHierarchySetting(argument: suspend GetHierarchySettingPlainArgsBuilder.() -> Unit):
        GetHierarchySettingResult {
        val builder = GetHierarchySettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHierarchySettingResultToKotlin(getHierarchySettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of the management group.
     * Azure REST API version: 2021-04-01.
     * Other available API versions: 2017-11-01-preview, 2020-02-01, 2023-04-01.
     * @param argument null
     * @return The management group details.
     */
    public suspend fun getManagementGroup(argument: GetManagementGroupPlainArgs):
        GetManagementGroupResult =
        getManagementGroupResultToKotlin(getManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getManagementGroup].
     * @param expand The $expand=children query string parameter allows clients to request inclusion of children in the response payload.  $expand=path includes the path from the root group to the current group.  $expand=ancestors includes the ancestor Ids of the current group.
     * @param filter A filter which allows the exclusion of subscriptions from results (i.e. '$filter=children.childType ne Subscription')
     * @param groupId Management Group ID.
     * @param recurse The $recurse=true query string parameter allows clients to request inclusion of entire hierarchy in the response payload. Note that  $expand=children must be passed up if $recurse is set to true.
     * @return The management group details.
     */
    public suspend fun getManagementGroup(
        expand: String? = null,
        filter: String? = null,
        groupId: String,
        recurse: Boolean? = null,
    ): GetManagementGroupResult {
        val argument = GetManagementGroupPlainArgs(
            expand = expand,
            filter = filter,
            groupId = groupId,
            recurse = recurse,
        )
        return getManagementGroupResultToKotlin(getManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;management&#46;kotlin&#46;inputs&#46;GetManagementGroupPlainArgs].
     * @return The management group details.
     */
    public suspend
    fun getManagementGroup(argument: suspend GetManagementGroupPlainArgsBuilder.() -> Unit):
        GetManagementGroupResult {
        val builder = GetManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementGroupResultToKotlin(getManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves details about given subscription which is associated with the management group.
     * Azure REST API version: 2021-04-01.
     * Other available API versions: 2023-04-01.
     * @param argument null
     * @return The details of subscription under management group.
     */
    public suspend
    fun getManagementGroupSubscription(argument: GetManagementGroupSubscriptionPlainArgs):
        GetManagementGroupSubscriptionResult =
        getManagementGroupSubscriptionResultToKotlin(getManagementGroupSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getManagementGroupSubscription].
     * @param groupId Management Group ID.
     * @param subscriptionId Subscription ID.
     * @return The details of subscription under management group.
     */
    public suspend fun getManagementGroupSubscription(
        groupId: String,
        subscriptionId: String? =
            null,
    ): GetManagementGroupSubscriptionResult {
        val argument = GetManagementGroupSubscriptionPlainArgs(
            groupId = groupId,
            subscriptionId = subscriptionId,
        )
        return getManagementGroupSubscriptionResultToKotlin(getManagementGroupSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementGroupSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;management&#46;kotlin&#46;inputs&#46;GetManagementGroupSubscriptionPlainArgs].
     * @return The details of subscription under management group.
     */
    public suspend
    fun getManagementGroupSubscription(argument: suspend GetManagementGroupSubscriptionPlainArgsBuilder.() -> Unit):
        GetManagementGroupSubscriptionResult {
        val builder = GetManagementGroupSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementGroupSubscriptionResultToKotlin(getManagementGroupSubscriptionPlain(builtArgument.toJava()).await())
    }
}
