@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.inputs

import com.pulumi.azurenative.management.inputs.GetHierarchySettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupId Management Group ID.
 */
public data class GetHierarchySettingPlainArgs(
    public val groupId: String,
) : ConvertibleToJava<com.pulumi.azurenative.management.inputs.GetHierarchySettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.management.inputs.GetHierarchySettingPlainArgs =
        com.pulumi.azurenative.management.inputs.GetHierarchySettingPlainArgs.builder()
            .groupId(groupId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHierarchySettingPlainArgs].
 */
@PulumiTagMarker
public class GetHierarchySettingPlainArgsBuilder internal constructor() {
    private var groupId: String? = null

    /**
     * @param value Management Group ID.
     */
    @JvmName("eculnvuxsjwyoyhk")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    internal fun build(): GetHierarchySettingPlainArgs = GetHierarchySettingPlainArgs(
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
    )
}
