@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.inputs

import com.pulumi.azurenative.management.inputs.GetManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The $expand=children query string parameter allows clients to request inclusion of children in the response payload.  $expand=path includes the path from the root group to the current group.  $expand=ancestors includes the ancestor Ids of the current group.
 * @property filter A filter which allows the exclusion of subscriptions from results (i.e. '$filter=children.childType ne Subscription')
 * @property groupId Management Group ID.
 * @property recurse The $recurse=true query string parameter allows clients to request inclusion of entire hierarchy in the response payload. Note that  $expand=children must be passed up if $recurse is set to true.
 */
public data class GetManagementGroupPlainArgs(
    public val expand: String? = null,
    public val filter: String? = null,
    public val groupId: String,
    public val recurse: Boolean? = null,
) : ConvertibleToJava<com.pulumi.azurenative.management.inputs.GetManagementGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.management.inputs.GetManagementGroupPlainArgs =
        com.pulumi.azurenative.management.inputs.GetManagementGroupPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 }))
            .groupId(groupId.let({ args0 -> args0 }))
            .recurse(recurse?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetManagementGroupPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var filter: String? = null

    private var groupId: String? = null

    private var recurse: Boolean? = null

    /**
     * @param value The $expand=children query string parameter allows clients to request inclusion of children in the response payload.  $expand=path includes the path from the root group to the current group.  $expand=ancestors includes the ancestor Ids of the current group.
     */
    @JvmName("kaqigvrkljcwasyv")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value A filter which allows the exclusion of subscriptions from results (i.e. '$filter=children.childType ne Subscription')
     */
    @JvmName("wkryfktdsswvelje")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value Management Group ID.
     */
    @JvmName("bwdjhpdthwgikoqj")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value The $recurse=true query string parameter allows clients to request inclusion of entire hierarchy in the response payload. Note that  $expand=children must be passed up if $recurse is set to true.
     */
    @JvmName("rskixtadyeghirof")
    public suspend fun recurse(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.recurse = mapped
    }

    internal fun build(): GetManagementGroupPlainArgs = GetManagementGroupPlainArgs(
        expand = expand,
        filter = filter,
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        recurse = recurse,
    )
}
