@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.inputs

import com.pulumi.azurenative.management.inputs.GetManagementGroupSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupId Management Group ID.
 * @property subscriptionId Subscription ID.
 */
public data class GetManagementGroupSubscriptionPlainArgs(
    public val groupId: String,
    public val subscriptionId: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.management.inputs.GetManagementGroupSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.management.inputs.GetManagementGroupSubscriptionPlainArgs =
        com.pulumi.azurenative.management.inputs.GetManagementGroupSubscriptionPlainArgs.builder()
            .groupId(groupId.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementGroupSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetManagementGroupSubscriptionPlainArgsBuilder internal constructor() {
    private var groupId: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value Management Group ID.
     */
    @JvmName("rjhupvduqvmxxmsk")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value Subscription ID.
     */
    @JvmName("ckaxmsvirjdfcuea")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): GetManagementGroupSubscriptionPlainArgs =
        GetManagementGroupSubscriptionPlainArgs(
            groupId = groupId ?: throw PulumiNullFieldException("groupId"),
            subscriptionId = subscriptionId,
        )
}
