@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The child information of a management group.
 * @property children The list of children.
 * @property displayName The friendly name of the child resource.
 * @property id The fully qualified ID for the child resource (management group or subscription).  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
 * @property name The name of the child entity.
 * @property type The fully qualified resource type which includes provider namespace (e.g. Microsoft.Management/managementGroups)
 */
public data class ManagementGroupChildInfoResponse(
    public val children: List<ManagementGroupChildInfoResponse>? = null,
    public val displayName: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.ManagementGroupChildInfoResponse):
            ManagementGroupChildInfoResponse = ManagementGroupChildInfoResponse(
            children = javaType.children().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupChildInfoResponse.Companion.toKotlin(args0)
                })
            }),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
