@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managementpartner.kotlin

import com.pulumi.azurenative.managementpartner.PartnerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * this is the management partner operations response
 * Azure REST API version: 2018-02-01. Prior API version in Azure Native 1.x: 2018-02-01.
 * ## Example Usage
 * ### PutPartnerDetails
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partner = new AzureNative.ManagementPartner.Partner("partner", new()
 *     {
 *         PartnerId = "123456",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managementpartner/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managementpartner.NewPartner(ctx, "partner", &managementpartner.PartnerArgs{
 * 			PartnerId: pulumi.String("123456"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managementpartner.Partner;
 * import com.pulumi.azurenative.managementpartner.PartnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partner = new Partner("partner", PartnerArgs.builder()
 *             .partnerId("123456")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managementpartner:Partner 123456 /providers/Microsoft.ManagementPartner/partners/{partnerId}
 * ```
 * @property partnerId Id of the Partner
 */
public data class PartnerArgs(
    public val partnerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managementpartner.PartnerArgs> {
    override fun toJava(): com.pulumi.azurenative.managementpartner.PartnerArgs =
        com.pulumi.azurenative.managementpartner.PartnerArgs.builder()
            .partnerId(partnerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartnerArgs].
 */
@PulumiTagMarker
public class PartnerArgsBuilder internal constructor() {
    private var partnerId: Output<String>? = null

    /**
     * @param value Id of the Partner
     */
    @JvmName("akmxfchinlnkdrur")
    public suspend fun partnerId(`value`: Output<String>) {
        this.partnerId = value
    }

    /**
     * @param value Id of the Partner
     */
    @JvmName("gityhtvtuuqimujc")
    public suspend fun partnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerId = mapped
    }

    internal fun build(): PartnerArgs = PartnerArgs(
        partnerId = partnerId,
    )
}
