@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin

import com.pulumi.azurenative.maps.AccountArgs.builder
import com.pulumi.azurenative.maps.kotlin.enums.Kind
import com.pulumi.azurenative.maps.kotlin.inputs.MapsAccountPropertiesArgs
import com.pulumi.azurenative.maps.kotlin.inputs.MapsAccountPropertiesArgsBuilder
import com.pulumi.azurenative.maps.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.maps.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure resource which represents access to a suite of Maps REST APIs.
 * Azure REST API version: 2021-02-01. Prior API version in Azure Native 1.x: 2018-05-01.
 * Other available API versions: 2018-05-01, 2021-12-01-preview, 2023-06-01, 2023-08-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create Gen1 Account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.Maps.Account("account", new()
 *     {
 *         AccountName = "myMapsAccount",
 *         Kind = "Gen1",
 *         Location = "global",
 *         Properties = new AzureNative.Maps.Inputs.MapsAccountPropertiesArgs
 *         {
 *             DisableLocalAuth = false,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Maps.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *         },
 *         Tags =
 *         {
 *             { "test", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maps/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maps.NewAccount(ctx, "account", &maps.AccountArgs{
 * 			AccountName: pulumi.String("myMapsAccount"),
 * 			Kind:        pulumi.String("Gen1"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: &maps.MapsAccountPropertiesArgs{
 * 				DisableLocalAuth: pulumi.Bool(false),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &maps.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"test": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maps.Account;
 * import com.pulumi.azurenative.maps.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("myMapsAccount")
 *             .kind("Gen1")
 *             .location("global")
 *             .properties(Map.of("disableLocalAuth", false))
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "S0"))
 *             .tags(Map.of("test", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Gen2 Account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.Maps.Account("account", new()
 *     {
 *         AccountName = "myMapsAccount",
 *         Kind = "Gen2",
 *         Location = "global",
 *         Properties = new AzureNative.Maps.Inputs.MapsAccountPropertiesArgs
 *         {
 *             DisableLocalAuth = true,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Maps.Inputs.SkuArgs
 *         {
 *             Name = "G2",
 *         },
 *         Tags =
 *         {
 *             { "test", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maps/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maps.NewAccount(ctx, "account", &maps.AccountArgs{
 * 			AccountName: pulumi.String("myMapsAccount"),
 * 			Kind:        pulumi.String("Gen2"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: &maps.MapsAccountPropertiesArgs{
 * 				DisableLocalAuth: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &maps.SkuArgs{
 * 				Name: pulumi.String("G2"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"test": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maps.Account;
 * import com.pulumi.azurenative.maps.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("myMapsAccount")
 *             .kind("Gen2")
 *             .location("global")
 *             .properties(Map.of("disableLocalAuth", true))
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "G2"))
 *             .tags(Map.of("test", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maps:Account myMapsAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}
 * ```
 * @property accountName The name of the Maps Account.
 * @property kind Get or Set Kind property.
 * @property location The geo-location where the resource lives
 * @property properties The map account properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU of this account.
 * @property tags Resource tags.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<MapsAccountPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maps.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.maps.AccountArgs =
        com.pulumi.azurenative.maps.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var location: Output<String>? = null

    private var properties: Output<MapsAccountPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Maps Account.
     */
    @JvmName("yykrfdjiiulnpamj")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Get or Set Kind property.
     */
    @JvmName("gnactujtgipbowbk")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("duuwtmvjktwcpaww")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The map account properties.
     */
    @JvmName("ejckufkdyuisecae")
    public suspend fun properties(`value`: Output<MapsAccountPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qrfqcedowuuddseg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of this account.
     */
    @JvmName("vfdfsffapjllfccl")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qptthdlnfgtjcmxn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Maps Account.
     */
    @JvmName("moslhiydexfttksy")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Get or Set Kind property.
     */
    @JvmName("dkyorgkeugiwkxmt")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Get or Set Kind property.
     */
    @JvmName("loxjlrqjigdashit")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Get or Set Kind property.
     */
    @JvmName("wmxptxmljshpgqxi")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qkailwpkpngnwdne")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The map account properties.
     */
    @JvmName("slhceveywramdxad")
    public suspend fun properties(`value`: MapsAccountPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The map account properties.
     */
    @JvmName("sviklbntxinmbcgu")
    public suspend fun properties(argument: suspend MapsAccountPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MapsAccountPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gbebgclpqsrhrbym")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of this account.
     */
    @JvmName("vdsfivkkqqnfmrkk")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of this account.
     */
    @JvmName("tslsrpljsuwdepxr")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qrxdgtycfiocjwvt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ehghgiitheeimmis")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        kind = kind,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
