@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin

import com.pulumi.azurenative.maps.kotlin.outputs.CreatorPropertiesResponse
import com.pulumi.azurenative.maps.kotlin.outputs.CreatorPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Creator].
 */
@PulumiTagMarker
public class CreatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CreatorArgs = CreatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CreatorArgsBuilder.() -> Unit) {
        val builder = CreatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Creator {
        val builtJavaResource = com.pulumi.azurenative.maps.Creator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Creator(builtJavaResource)
    }
}

/**
 * An Azure resource which represents Maps Creator product and provides ability to manage private location data.
 * Azure REST API version: 2021-02-01. Prior API version in Azure Native 1.x: 2020-02-01-preview.
 * Other available API versions: 2020-02-01-preview, 2021-12-01-preview, 2023-06-01, 2023-08-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create Creator Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var creator = new AzureNative.Maps.Creator("creator", new()
 *     {
 *         AccountName = "myMapsAccount",
 *         CreatorName = "myCreator",
 *         Location = "eastus2",
 *         Properties = new AzureNative.Maps.Inputs.CreatorPropertiesArgs
 *         {
 *             StorageUnits = 5,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "test", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maps/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maps.NewCreator(ctx, "creator", &maps.CreatorArgs{
 * 			AccountName: pulumi.String("myMapsAccount"),
 * 			CreatorName: pulumi.String("myCreator"),
 * 			Location:    pulumi.String("eastus2"),
 * 			Properties: &maps.CreatorPropertiesArgs{
 * 				StorageUnits: pulumi.Int(5),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"test": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maps.Creator;
 * import com.pulumi.azurenative.maps.CreatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var creator = new Creator("creator", CreatorArgs.builder()
 *             .accountName("myMapsAccount")
 *             .creatorName("myCreator")
 *             .location("eastus2")
 *             .properties(Map.of("storageUnits", 5))
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("test", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maps:Creator myCreator /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}/creators/{creatorName}
 * ```
 */
public class Creator internal constructor(
    override val javaResource: com.pulumi.azurenative.maps.Creator,
) : KotlinCustomResource(javaResource, CreatorMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Creator resource properties.
     */
    public val properties: Output<CreatorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CreatorMapper : ResourceMapper<Creator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.maps.Creator::class == javaResource::class

    override fun map(javaResource: Resource): Creator = Creator(
        javaResource as
            com.pulumi.azurenative.maps.Creator,
    )
}

/**
 * @see [Creator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Creator].
 */
public suspend fun creator(name: String, block: suspend CreatorResourceBuilder.() -> Unit):
    Creator {
    val builder = CreatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Creator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun creator(name: String): Creator {
    val builder = CreatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
