@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin

import com.pulumi.azurenative.maps.MapsFunctions.getAccountPlain
import com.pulumi.azurenative.maps.MapsFunctions.getCreatorPlain
import com.pulumi.azurenative.maps.MapsFunctions.getPrivateAtlasePlain
import com.pulumi.azurenative.maps.MapsFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.maps.MapsFunctions.listAccountKeysPlain
import com.pulumi.azurenative.maps.MapsFunctions.listAccountSasPlain
import com.pulumi.azurenative.maps.kotlin.enums.SigningKey
import com.pulumi.azurenative.maps.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.maps.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.maps.kotlin.inputs.GetCreatorPlainArgs
import com.pulumi.azurenative.maps.kotlin.inputs.GetCreatorPlainArgsBuilder
import com.pulumi.azurenative.maps.kotlin.inputs.GetPrivateAtlasePlainArgs
import com.pulumi.azurenative.maps.kotlin.inputs.GetPrivateAtlasePlainArgsBuilder
import com.pulumi.azurenative.maps.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.maps.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.maps.kotlin.inputs.ListAccountKeysPlainArgs
import com.pulumi.azurenative.maps.kotlin.inputs.ListAccountKeysPlainArgsBuilder
import com.pulumi.azurenative.maps.kotlin.inputs.ListAccountSasPlainArgs
import com.pulumi.azurenative.maps.kotlin.inputs.ListAccountSasPlainArgsBuilder
import com.pulumi.azurenative.maps.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.maps.kotlin.outputs.GetCreatorResult
import com.pulumi.azurenative.maps.kotlin.outputs.GetPrivateAtlaseResult
import com.pulumi.azurenative.maps.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.maps.kotlin.outputs.ListAccountKeysResult
import com.pulumi.azurenative.maps.kotlin.outputs.ListAccountSasResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.maps.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.maps.kotlin.outputs.GetCreatorResult.Companion.toKotlin as getCreatorResultToKotlin
import com.pulumi.azurenative.maps.kotlin.outputs.GetPrivateAtlaseResult.Companion.toKotlin as getPrivateAtlaseResultToKotlin
import com.pulumi.azurenative.maps.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.maps.kotlin.outputs.ListAccountKeysResult.Companion.toKotlin as listAccountKeysResultToKotlin
import com.pulumi.azurenative.maps.kotlin.outputs.ListAccountSasResult.Companion.toKotlin as listAccountSasResultToKotlin

public object MapsFunctions {
    /**
     * Get a Maps Account.
     * Azure REST API version: 2021-02-01.
     * Other available API versions: 2018-05-01, 2021-12-01-preview, 2023-06-01, 2023-08-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return An Azure resource which represents access to a suite of Maps REST APIs.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the Maps Account.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure resource which represents access to a suite of Maps REST APIs.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maps&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return An Azure resource which represents access to a suite of Maps REST APIs.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Maps Creator resource.
     * Azure REST API version: 2021-02-01.
     * Other available API versions: 2020-02-01-preview, 2021-12-01-preview, 2023-06-01, 2023-08-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return An Azure resource which represents Maps Creator product and provides ability to manage private location data.
     */
    public suspend fun getCreator(argument: GetCreatorPlainArgs): GetCreatorResult =
        getCreatorResultToKotlin(getCreatorPlain(argument.toJava()).await())

    /**
     * @see [getCreator].
     * @param accountName The name of the Maps Account.
     * @param creatorName The name of the Maps Creator instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure resource which represents Maps Creator product and provides ability to manage private location data.
     */
    public suspend fun getCreator(
        accountName: String,
        creatorName: String,
        resourceGroupName: String,
    ): GetCreatorResult {
        val argument = GetCreatorPlainArgs(
            accountName = accountName,
            creatorName = creatorName,
            resourceGroupName = resourceGroupName,
        )
        return getCreatorResultToKotlin(getCreatorPlain(argument.toJava()).await())
    }

    /**
     * @see [getCreator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maps&#46;kotlin&#46;inputs&#46;GetCreatorPlainArgs].
     * @return An Azure resource which represents Maps Creator product and provides ability to manage private location data.
     */
    public suspend fun getCreator(argument: suspend GetCreatorPlainArgsBuilder.() -> Unit):
        GetCreatorResult {
        val builder = GetCreatorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCreatorResultToKotlin(getCreatorPlain(builtArgument.toJava()).await())
    }

    /**
     * [Deprecated] Get a Private Atlas resource.
     * Azure REST API version: 2020-02-01-preview.
     * @param argument null
     * @return An Azure resource which represents which will provision the ability to create private location data.
     */
    public suspend fun getPrivateAtlase(argument: GetPrivateAtlasePlainArgs): GetPrivateAtlaseResult =
        getPrivateAtlaseResultToKotlin(getPrivateAtlasePlain(argument.toJava()).await())

    /**
     * @see [getPrivateAtlase].
     * @param accountName The name of the Maps Account.
     * @param privateAtlasName The name of the Private Atlas instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure resource which represents which will provision the ability to create private location data.
     */
    public suspend fun getPrivateAtlase(
        accountName: String,
        privateAtlasName: String,
        resourceGroupName: String,
    ): GetPrivateAtlaseResult {
        val argument = GetPrivateAtlasePlainArgs(
            accountName = accountName,
            privateAtlasName = privateAtlasName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateAtlaseResultToKotlin(getPrivateAtlasePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateAtlase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maps&#46;kotlin&#46;inputs&#46;GetPrivateAtlasePlainArgs].
     * @return An Azure resource which represents which will provision the ability to create private location data.
     */
    public suspend
    fun getPrivateAtlase(argument: suspend GetPrivateAtlasePlainArgsBuilder.() -> Unit):
        GetPrivateAtlaseResult {
        val builder = GetPrivateAtlasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateAtlaseResultToKotlin(getPrivateAtlasePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the Maps Account.
     * Azure REST API version: 2023-12-01-preview.
     * @param argument null
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param accountName The name of the Maps Account.
     * @param privateEndpointConnectionName The name of the Private Endpoint Connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        accountName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maps&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the keys to use with the Maps APIs. A key is used to authenticate and authorize access to the Maps REST APIs. Only one key is needed at a time; two are given to provide seamless key regeneration.
     * Azure REST API version: 2021-02-01.
     * Other available API versions: 2018-05-01, 2021-12-01-preview, 2023-06-01, 2023-08-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return The set of keys which can be used to access the Maps REST APIs. Two keys are provided for key rotation without interruption.
     */
    public suspend fun listAccountKeys(argument: ListAccountKeysPlainArgs): ListAccountKeysResult =
        listAccountKeysResultToKotlin(listAccountKeysPlain(argument.toJava()).await())

    /**
     * @see [listAccountKeys].
     * @param accountName The name of the Maps Account.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The set of keys which can be used to access the Maps REST APIs. Two keys are provided for key rotation without interruption.
     */
    public suspend fun listAccountKeys(accountName: String, resourceGroupName: String):
        ListAccountKeysResult {
        val argument = ListAccountKeysPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return listAccountKeysResultToKotlin(listAccountKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccountKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maps&#46;kotlin&#46;inputs&#46;ListAccountKeysPlainArgs].
     * @return The set of keys which can be used to access the Maps REST APIs. Two keys are provided for key rotation without interruption.
     */
    public suspend fun listAccountKeys(argument: suspend ListAccountKeysPlainArgsBuilder.() -> Unit):
        ListAccountKeysResult {
        val builder = ListAccountKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccountKeysResultToKotlin(listAccountKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Create and list an account shared access signature token. Use this SAS token for authentication to Azure Maps REST APIs through various Azure Maps SDKs. As prerequisite to create a SAS Token.
     * Prerequisites:
     * 1. Create or have an existing User Assigned Managed Identity in the same Azure region as the account.
     * 2. Create or update an Azure Map account with the same Azure region as the User Assigned Managed Identity is placed.
     * Azure REST API version: 2021-12-01-preview.
     * Other available API versions: 2023-06-01, 2023-08-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return A new Sas token which can be used to access the Maps REST APIs and is controlled by the specified Managed identity permissions on Azure (IAM) Role Based Access Control.
     */
    public suspend fun listAccountSas(argument: ListAccountSasPlainArgs): ListAccountSasResult =
        listAccountSasResultToKotlin(listAccountSasPlain(argument.toJava()).await())

    /**
     * @see [listAccountSas].
     * @param accountName The name of the Maps Account.
     * @param expiry The date time offset of when the token validity expires. For example "2017-05-24T10:42:03.1567373Z"
     * @param maxRatePerSecond Required parameter which represents the desired maximum request per second to allowed for the given SAS token. This does not guarantee perfect accuracy in measurements but provides application safe guards of abuse with eventual enforcement.
     * @param principalId The principal Id also known as the object Id of a User Assigned Managed Identity currently assigned to the Map Account. To assign a Managed Identity of the account, use operation Create or Update an assign a User Assigned Identity resource Id.
     * @param regions Optional, allows control of which region locations are permitted access to Azure Maps REST APIs with the SAS token. Example: "eastus", "westus2". Omitting this parameter will allow all region locations to be accessible.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param signingKey The Map account key to use for signing.
     * @param start The date time offset of when the token validity begins. For example "2017-05-24T10:42:03.1567373Z".
     * @return A new Sas token which can be used to access the Maps REST APIs and is controlled by the specified Managed identity permissions on Azure (IAM) Role Based Access Control.
     */
    public suspend fun listAccountSas(
        accountName: String,
        expiry: String,
        maxRatePerSecond: Int,
        principalId: String,
        regions: List<String>? = null,
        resourceGroupName: String,
        signingKey: Either<String, SigningKey>,
        start: String,
    ): ListAccountSasResult {
        val argument = ListAccountSasPlainArgs(
            accountName = accountName,
            expiry = expiry,
            maxRatePerSecond = maxRatePerSecond,
            principalId = principalId,
            regions = regions,
            resourceGroupName = resourceGroupName,
            signingKey = signingKey,
            start = start,
        )
        return listAccountSasResultToKotlin(listAccountSasPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccountSas].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maps&#46;kotlin&#46;inputs&#46;ListAccountSasPlainArgs].
     * @return A new Sas token which can be used to access the Maps REST APIs and is controlled by the specified Managed identity permissions on Azure (IAM) Role Based Access Control.
     */
    public suspend fun listAccountSas(argument: suspend ListAccountSasPlainArgsBuilder.() -> Unit):
        ListAccountSasResult {
        val builder = ListAccountSasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccountSasResultToKotlin(listAccountSasPlain(builtArgument.toJava()).await())
    }
}
