@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The set of keys which can be used to access the Maps REST APIs. Two keys are provided for key rotation without interruption.
 * @property primaryKey The primary key for accessing the Maps REST APIs.
 * @property primaryKeyLastUpdated The last updated date and time of the primary key.
 * @property secondaryKey The secondary key for accessing the Maps REST APIs.
 * @property secondaryKeyLastUpdated The last updated date and time of the secondary key.
 */
public data class ListAccountKeysResult(
    public val primaryKey: String,
    public val primaryKeyLastUpdated: String,
    public val secondaryKey: String,
    public val secondaryKeyLastUpdated: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maps.outputs.ListAccountKeysResult):
            ListAccountKeysResult = ListAccountKeysResult(
            primaryKey = javaType.primaryKey(),
            primaryKeyLastUpdated = javaType.primaryKeyLastUpdated(),
            secondaryKey = javaType.secondaryKey(),
            secondaryKeyLastUpdated = javaType.secondaryKeyLastUpdated(),
        )
    }
}
