@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Collection data structure.
 * @property allSubscriptions Indicating whether all subscriptions are selected (=true) or not (=false).
 * @property appliedRules Gets list of collection rules
 * @property approveAllItems Indicating whether all items are approved for this collection (=true) or not (=false).
 * @property approveAllItemsModifiedAt Gets the modified date of all items approved.
 * @property claim Gets or sets the association with Commercial's Billing Account.
 * @property collectionId Gets collection Id.
 * @property collectionName Gets or sets collection name.
 * @property enabled Indicating whether the collection is enabled or disabled.
 * @property id The resource ID.
 * @property name The name of the resource.
 * @property numberOfOffers Gets the number of offers associated with the collection.
 * @property subscriptionsList Gets or sets subscription ids list. Empty list indicates all subscriptions are selected, null indicates no update is done, explicit list indicates the explicit selected subscriptions. On insert, null is considered as bad request
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property type The type of the resource.
 */
public data class GetPrivateStoreCollectionResult(
    public val allSubscriptions: Boolean? = null,
    public val appliedRules: List<RuleResponse>,
    public val approveAllItems: Boolean,
    public val approveAllItemsModifiedAt: String,
    public val claim: String? = null,
    public val collectionId: String,
    public val collectionName: String? = null,
    public val enabled: Boolean? = null,
    public val id: String,
    public val name: String,
    public val numberOfOffers: Double,
    public val subscriptionsList: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.marketplace.outputs.GetPrivateStoreCollectionResult):
            GetPrivateStoreCollectionResult = GetPrivateStoreCollectionResult(
            allSubscriptions = javaType.allSubscriptions().map({ args0 -> args0 }).orElse(null),
            appliedRules = javaType.appliedRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.marketplace.kotlin.outputs.RuleResponse.Companion.toKotlin(args0)
                })
            }),
            approveAllItems = javaType.approveAllItems(),
            approveAllItemsModifiedAt = javaType.approveAllItemsModifiedAt(),
            claim = javaType.claim().map({ args0 -> args0 }).orElse(null),
            collectionId = javaType.collectionId(),
            collectionName = javaType.collectionName().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            numberOfOffers = javaType.numberOfOffers(),
            subscriptionsList = javaType.subscriptionsList().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.marketplace.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
