@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.AccountFilterArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.FilterTrackSelectionArgs
import com.pulumi.azurenative.media.kotlin.inputs.FilterTrackSelectionArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.FirstQualityArgs
import com.pulumi.azurenative.media.kotlin.inputs.FirstQualityArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.PresentationTimeRangeArgs
import com.pulumi.azurenative.media.kotlin.inputs.PresentationTimeRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Account Filter.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create an Account Filter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accountFilter = new AzureNative.Media.AccountFilter("accountFilter", new()
 *     {
 *         AccountName = "contosomedia",
 *         FilterName = "newAccountFilter",
 *         FirstQuality = new AzureNative.Media.Inputs.FirstQualityArgs
 *         {
 *             Bitrate = 128000,
 *         },
 *         PresentationTimeRange = new AzureNative.Media.Inputs.PresentationTimeRangeArgs
 *         {
 *             EndTimestamp = 170000000,
 *             ForceEndTimestamp = false,
 *             LiveBackoffDuration = 0,
 *             PresentationWindowDuration = 9223372036854774784,
 *             StartTimestamp = 0,
 *             Timescale = 10000000,
 *         },
 *         ResourceGroupName = "contosorg",
 *         Tracks = new[]
 *         {
 *             new AzureNative.Media.Inputs.FilterTrackSelectionArgs
 *             {
 *                 TrackSelections = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Type",
 *                         Value = "Audio",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "NotEqual",
 *                         Property = "Language",
 *                         Value = "en",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "NotEqual",
 *                         Property = "FourCC",
 *                         Value = "EC-3",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Media.Inputs.FilterTrackSelectionArgs
 *             {
 *                 TrackSelections = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Type",
 *                         Value = "Video",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Bitrate",
 *                         Value = "3000000-5000000",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewAccountFilter(ctx, "accountFilter", &media.AccountFilterArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			FilterName:  pulumi.String("newAccountFilter"),
 * 			FirstQuality: &media.FirstQualityArgs{
 * 				Bitrate: pulumi.Int(128000),
 * 			},
 * 			PresentationTimeRange: &media.PresentationTimeRangeArgs{
 * 				EndTimestamp:               pulumi.Float64(170000000),
 * 				ForceEndTimestamp:          pulumi.Bool(false),
 * 				LiveBackoffDuration:        pulumi.Float64(0),
 * 				PresentationWindowDuration: pulumi.Float64(9223372036854774784),
 * 				StartTimestamp:             pulumi.Float64(0),
 * 				Timescale:                  pulumi.Float64(10000000),
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			Tracks: []media.FilterTrackSelectionArgs{
 * 				{
 * 					TrackSelections: media.FilterTrackPropertyConditionArray{
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Type"),
 * 							Value:     pulumi.String("Audio"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("NotEqual"),
 * 							Property:  pulumi.String("Language"),
 * 							Value:     pulumi.String("en"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("NotEqual"),
 * 							Property:  pulumi.String("FourCC"),
 * 							Value:     pulumi.String("EC-3"),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					TrackSelections: media.FilterTrackPropertyConditionArray{
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Type"),
 * 							Value:     pulumi.String("Video"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Bitrate"),
 * 							Value:     pulumi.String("3000000-5000000"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.AccountFilter;
 * import com.pulumi.azurenative.media.AccountFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accountFilter = new AccountFilter("accountFilter", AccountFilterArgs.builder()
 *             .accountName("contosomedia")
 *             .filterName("newAccountFilter")
 *             .firstQuality(Map.of("bitrate", 128000))
 *             .presentationTimeRange(Map.ofEntries(
 *                 Map.entry("endTimestamp", 170000000),
 *                 Map.entry("forceEndTimestamp", false),
 *                 Map.entry("liveBackoffDuration", 0),
 *                 Map.entry("presentationWindowDuration", 9223372036854774784),
 *                 Map.entry("startTimestamp", 0),
 *                 Map.entry("timescale", 10000000)
 *             ))
 *             .resourceGroupName("contosorg")
 *             .tracks(
 *                 Map.of("trackSelections",
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Type"),
 *                         Map.entry("value", "Audio")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "NotEqual"),
 *                         Map.entry("property", "Language"),
 *                         Map.entry("value", "en")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "NotEqual"),
 *                         Map.entry("property", "FourCC"),
 *                         Map.entry("value", "EC-3")
 *                     )),
 *                 Map.of("trackSelections",
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Type"),
 *                         Map.entry("value", "Video")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Bitrate"),
 *                         Map.entry("value", "3000000-5000000")
 *                     )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:AccountFilter newAccountFilter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/accountFilters/{filterName}
 * ```
 * @property accountName The Media Services account name.
 * @property filterName The Account Filter name
 * @property firstQuality The first quality.
 * @property presentationTimeRange The presentation time range.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property tracks The tracks selection conditions.
 */
public data class AccountFilterArgs(
    public val accountName: Output<String>? = null,
    public val filterName: Output<String>? = null,
    public val firstQuality: Output<FirstQualityArgs>? = null,
    public val presentationTimeRange: Output<PresentationTimeRangeArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tracks: Output<List<FilterTrackSelectionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.AccountFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.media.AccountFilterArgs =
        com.pulumi.azurenative.media.AccountFilterArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .filterName(filterName?.applyValue({ args0 -> args0 }))
            .firstQuality(firstQuality?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presentationTimeRange(
                presentationTimeRange?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tracks(
                tracks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccountFilterArgs].
 */
@PulumiTagMarker
public class AccountFilterArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var filterName: Output<String>? = null

    private var firstQuality: Output<FirstQualityArgs>? = null

    private var presentationTimeRange: Output<PresentationTimeRangeArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tracks: Output<List<FilterTrackSelectionArgs>>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("eyoqegsvjwthgvrc")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The Account Filter name
     */
    @JvmName("nvagptyhjghklegj")
    public suspend fun filterName(`value`: Output<String>) {
        this.filterName = value
    }

    /**
     * @param value The first quality.
     */
    @JvmName("qkkkfbdroiarnwys")
    public suspend fun firstQuality(`value`: Output<FirstQualityArgs>) {
        this.firstQuality = value
    }

    /**
     * @param value The presentation time range.
     */
    @JvmName("spluiwodmdertdvp")
    public suspend fun presentationTimeRange(`value`: Output<PresentationTimeRangeArgs>) {
        this.presentationTimeRange = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("rqywqescrjokvfrf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tracks selection conditions.
     */
    @JvmName("dspwhqtqqvividoh")
    public suspend fun tracks(`value`: Output<List<FilterTrackSelectionArgs>>) {
        this.tracks = value
    }

    @JvmName("winxbcrtghgmxihc")
    public suspend fun tracks(vararg values: Output<FilterTrackSelectionArgs>) {
        this.tracks = Output.all(values.asList())
    }

    /**
     * @param values The tracks selection conditions.
     */
    @JvmName("ipbcsdhyumandutb")
    public suspend fun tracks(values: List<Output<FilterTrackSelectionArgs>>) {
        this.tracks = Output.all(values)
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("xrnddbjlyrtumbns")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The Account Filter name
     */
    @JvmName("nbragdhrdywlrhou")
    public suspend fun filterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterName = mapped
    }

    /**
     * @param value The first quality.
     */
    @JvmName("nnffefrdgrifbbsp")
    public suspend fun firstQuality(`value`: FirstQualityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstQuality = mapped
    }

    /**
     * @param argument The first quality.
     */
    @JvmName("qqfkkqijwhjdxmyg")
    public suspend fun firstQuality(argument: suspend FirstQualityArgsBuilder.() -> Unit) {
        val toBeMapped = FirstQualityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firstQuality = mapped
    }

    /**
     * @param value The presentation time range.
     */
    @JvmName("prrxdmjkunqrrjhn")
    public suspend fun presentationTimeRange(`value`: PresentationTimeRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presentationTimeRange = mapped
    }

    /**
     * @param argument The presentation time range.
     */
    @JvmName("qkygmosbbwsxwkok")
    public suspend
    fun presentationTimeRange(argument: suspend PresentationTimeRangeArgsBuilder.() -> Unit) {
        val toBeMapped = PresentationTimeRangeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presentationTimeRange = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("yadnifawukbdhdnq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tracks selection conditions.
     */
    @JvmName("ejxfkpicbyobaxxr")
    public suspend fun tracks(`value`: List<FilterTrackSelectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("eqbfpsalheytigve")
    public suspend fun tracks(argument: List<suspend FilterTrackSelectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilterTrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("ygxjnmqyvimcbpxc")
    public suspend fun tracks(vararg argument: suspend FilterTrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FilterTrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("pjrpbdsujjfvbtkd")
    public suspend fun tracks(argument: suspend FilterTrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilterTrackSelectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param values The tracks selection conditions.
     */
    @JvmName("uxqosbqlaxigfmrv")
    public suspend fun tracks(vararg values: FilterTrackSelectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    internal fun build(): AccountFilterArgs = AccountFilterArgs(
        accountName = accountName,
        filterName = filterName,
        firstQuality = firstQuality,
        presentationTimeRange = presentationTimeRange,
        resourceGroupName = resourceGroupName,
        tracks = tracks,
    )
}
