@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.AccountEncryptionResponse
import com.pulumi.azurenative.media.kotlin.outputs.KeyDeliveryResponse
import com.pulumi.azurenative.media.kotlin.outputs.MediaServiceIdentityResponse
import com.pulumi.azurenative.media.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.media.kotlin.outputs.StorageAccountResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.media.kotlin.outputs.AccountEncryptionResponse.Companion.toKotlin as accountEncryptionResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.KeyDeliveryResponse.Companion.toKotlin as keyDeliveryResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.MediaServiceIdentityResponse.Companion.toKotlin as mediaServiceIdentityResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.StorageAccountResponse.Companion.toKotlin as storageAccountResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MediaService].
 */
@PulumiTagMarker
public class MediaServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MediaServiceArgs = MediaServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MediaServiceArgsBuilder.() -> Unit) {
        val builder = MediaServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MediaService {
        val builtJavaResource = com.pulumi.azurenative.media.MediaService(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MediaService(builtJavaResource)
    }
}

/**
 * A Media Services account.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2015-10-01.
 * ## Example Usage
 * ### Create a Media Services account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mediaService = new AzureNative.Media.MediaService("mediaService", new()
 *     {
 *         AccountName = "contososports",
 *         Location = "South Central US",
 *         ResourceGroupName = "contosorg",
 *         StorageAccounts = new[]
 *         {
 *             new AzureNative.Media.Inputs.StorageAccountArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosorg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 *                 Type = "Primary",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewMediaService(ctx, "mediaService", &media.MediaServiceArgs{
 * 			AccountName:       pulumi.String("contososports"),
 * 			Location:          pulumi.String("South Central US"),
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			StorageAccounts: []media.StorageAccountArgs{
 * 				{
 * 					Id:   pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosorg/providers/Microsoft.Storage/storageAccounts/teststorageaccount"),
 * 					Type: pulumi.String("Primary"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.MediaService;
 * import com.pulumi.azurenative.media.MediaServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mediaService = new MediaService("mediaService", MediaServiceArgs.builder()
 *             .accountName("contososports")
 *             .location("South Central US")
 *             .resourceGroupName("contosorg")
 *             .storageAccounts(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosorg/providers/Microsoft.Storage/storageAccounts/teststorageaccount"),
 *                 Map.entry("type", "Primary")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:MediaService contososports /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}
 * ```
 */
public class MediaService internal constructor(
    override val javaResource: com.pulumi.azurenative.media.MediaService,
) : KotlinCustomResource(javaResource, MediaServiceMapper) {
    /**
     * The account encryption properties.
     */
    public val encryption: Output<AccountEncryptionResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accountEncryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Managed Identity for the Media Services account.
     */
    public val identity: Output<MediaServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mediaServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Key Delivery properties for Media Services account.
     */
    public val keyDelivery: Output<KeyDeliveryResponse>?
        get() = javaResource.keyDelivery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    keyDeliveryResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The Media Services account ID.
     */
    public val mediaServiceId: Output<String>
        get() = javaResource.mediaServiceId().applyValue({ args0 -> args0 })

    /**
     * The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
     */
    public val minimumTlsVersion: Output<String>?
        get() = javaResource.minimumTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Private Endpoint Connections created for the Media Service account.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state of the Media Services account.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Whether or not public network access is allowed for resources under the Media Services account.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage accounts for this resource.
     */
    public val storageAccounts: Output<List<StorageAccountResponse>>?
        get() = javaResource.storageAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        storageAccountResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    public val storageAuthentication: Output<String>?
        get() = javaResource.storageAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MediaServiceMapper : ResourceMapper<MediaService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.MediaService::class == javaResource::class

    override fun map(javaResource: Resource): MediaService = MediaService(
        javaResource as
            com.pulumi.azurenative.media.MediaService,
    )
}

/**
 * @see [MediaService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MediaService].
 */
public suspend fun mediaService(
    name: String,
    block: suspend MediaServiceResourceBuilder.() -> Unit,
): MediaService {
    val builder = MediaServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MediaService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mediaService(name: String): MediaService {
    val builder = MediaServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
