@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.MediaServiceArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.MinimumTlsVersion
import com.pulumi.azurenative.media.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.media.kotlin.enums.StorageAuthentication
import com.pulumi.azurenative.media.kotlin.inputs.AccountEncryptionArgs
import com.pulumi.azurenative.media.kotlin.inputs.AccountEncryptionArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.KeyDeliveryArgs
import com.pulumi.azurenative.media.kotlin.inputs.KeyDeliveryArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.MediaServiceIdentityArgs
import com.pulumi.azurenative.media.kotlin.inputs.MediaServiceIdentityArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.StorageAccountArgs
import com.pulumi.azurenative.media.kotlin.inputs.StorageAccountArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Media Services account.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2015-10-01.
 * ## Example Usage
 * ### Create a Media Services account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mediaService = new AzureNative.Media.MediaService("mediaService", new()
 *     {
 *         AccountName = "contososports",
 *         Location = "South Central US",
 *         ResourceGroupName = "contosorg",
 *         StorageAccounts = new[]
 *         {
 *             new AzureNative.Media.Inputs.StorageAccountArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosorg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 *                 Type = "Primary",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewMediaService(ctx, "mediaService", &media.MediaServiceArgs{
 * 			AccountName:       pulumi.String("contososports"),
 * 			Location:          pulumi.String("South Central US"),
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			StorageAccounts: []media.StorageAccountArgs{
 * 				{
 * 					Id:   pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosorg/providers/Microsoft.Storage/storageAccounts/teststorageaccount"),
 * 					Type: pulumi.String("Primary"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.MediaService;
 * import com.pulumi.azurenative.media.MediaServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mediaService = new MediaService("mediaService", MediaServiceArgs.builder()
 *             .accountName("contososports")
 *             .location("South Central US")
 *             .resourceGroupName("contosorg")
 *             .storageAccounts(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosorg/providers/Microsoft.Storage/storageAccounts/teststorageaccount"),
 *                 Map.entry("type", "Primary")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:MediaService contososports /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}
 * ```
 * @property accountName The Media Services account name.
 * @property encryption The account encryption properties.
 * @property identity The Managed Identity for the Media Services account.
 * @property keyDelivery The Key Delivery properties for Media Services account.
 * @property location The geo-location where the resource lives
 * @property minimumTlsVersion The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
 * @property publicNetworkAccess Whether or not public network access is allowed for resources under the Media Services account.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property storageAccounts The storage accounts for this resource.
 * @property storageAuthentication
 * @property tags Resource tags.
 */
public data class MediaServiceArgs(
    public val accountName: Output<String>? = null,
    public val encryption: Output<AccountEncryptionArgs>? = null,
    public val identity: Output<MediaServiceIdentityArgs>? = null,
    public val keyDelivery: Output<KeyDeliveryArgs>? = null,
    public val location: Output<String>? = null,
    public val minimumTlsVersion: Output<Either<String, MinimumTlsVersion>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccounts: Output<List<StorageAccountArgs>>? = null,
    public val storageAuthentication: Output<Either<String, StorageAuthentication>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.MediaServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.media.MediaServiceArgs =
        com.pulumi.azurenative.media.MediaServiceArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyDelivery(keyDelivery?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumTlsVersion(
                minimumTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccounts(
                storageAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageAuthentication(
                storageAuthentication?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MediaServiceArgs].
 */
@PulumiTagMarker
public class MediaServiceArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var encryption: Output<AccountEncryptionArgs>? = null

    private var identity: Output<MediaServiceIdentityArgs>? = null

    private var keyDelivery: Output<KeyDeliveryArgs>? = null

    private var location: Output<String>? = null

    private var minimumTlsVersion: Output<Either<String, MinimumTlsVersion>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccounts: Output<List<StorageAccountArgs>>? = null

    private var storageAuthentication: Output<Either<String, StorageAuthentication>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("bhgqcelsnspukxbr")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The account encryption properties.
     */
    @JvmName("itrlriqxcegadmcu")
    public suspend fun encryption(`value`: Output<AccountEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The Managed Identity for the Media Services account.
     */
    @JvmName("kpxtulwlfrteuvuq")
    public suspend fun identity(`value`: Output<MediaServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The Key Delivery properties for Media Services account.
     */
    @JvmName("xnagdfrgyrfkhrmb")
    public suspend fun keyDelivery(`value`: Output<KeyDeliveryArgs>) {
        this.keyDelivery = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dbffsgnqkgjpvtbx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
     */
    @JvmName("qfdydntgbllamsnc")
    public suspend fun minimumTlsVersion(`value`: Output<Either<String, MinimumTlsVersion>>) {
        this.minimumTlsVersion = value
    }

    /**
     * @param value Whether or not public network access is allowed for resources under the Media Services account.
     */
    @JvmName("ioopifjpejbjiyos")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("goicroaokspbjwjo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The storage accounts for this resource.
     */
    @JvmName("wohklrrcfbjfikpm")
    public suspend fun storageAccounts(`value`: Output<List<StorageAccountArgs>>) {
        this.storageAccounts = value
    }

    @JvmName("coglcrgiyvgvqcvl")
    public suspend fun storageAccounts(vararg values: Output<StorageAccountArgs>) {
        this.storageAccounts = Output.all(values.asList())
    }

    /**
     * @param values The storage accounts for this resource.
     */
    @JvmName("qicujmgkaoobtqkw")
    public suspend fun storageAccounts(values: List<Output<StorageAccountArgs>>) {
        this.storageAccounts = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iumnthyovscjnhtj")
    public suspend fun storageAuthentication(`value`: Output<Either<String, StorageAuthentication>>) {
        this.storageAuthentication = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("airqqfngyilauyrb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("ndtbunwbiwccvduu")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The account encryption properties.
     */
    @JvmName("jqijpipfdnrejyyq")
    public suspend fun encryption(`value`: AccountEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The account encryption properties.
     */
    @JvmName("uthucowvksbcehcn")
    public suspend fun encryption(argument: suspend AccountEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = AccountEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The Managed Identity for the Media Services account.
     */
    @JvmName("fhahrcvjfsxqdvnm")
    public suspend fun identity(`value`: MediaServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The Managed Identity for the Media Services account.
     */
    @JvmName("tnfargagnwjxsmbw")
    public suspend fun identity(argument: suspend MediaServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = MediaServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The Key Delivery properties for Media Services account.
     */
    @JvmName("epnqwbociddvwtvr")
    public suspend fun keyDelivery(`value`: KeyDeliveryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyDelivery = mapped
    }

    /**
     * @param argument The Key Delivery properties for Media Services account.
     */
    @JvmName("vutiptyyfsfmlwdn")
    public suspend fun keyDelivery(argument: suspend KeyDeliveryArgsBuilder.() -> Unit) {
        val toBeMapped = KeyDeliveryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyDelivery = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pvskgdnmywxwiuuj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
     */
    @JvmName("rwwarpkjonuxpdjn")
    public suspend fun minimumTlsVersion(`value`: Either<String, MinimumTlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
     */
    @JvmName("hewsawrqluesabtq")
    public fun minimumTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MinimumTlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
     */
    @JvmName("drkfrtrhuhypajbh")
    public fun minimumTlsVersion(`value`: MinimumTlsVersion) {
        val toBeMapped = Either.ofRight<String, MinimumTlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for resources under the Media Services account.
     */
    @JvmName("yarxviyplsbgcnah")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for resources under the Media Services account.
     */
    @JvmName("ycfdvpvludfthoaj")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for resources under the Media Services account.
     */
    @JvmName("dkwcawedudysfqad")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("owlgcdcsytfxrlpn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The storage accounts for this resource.
     */
    @JvmName("aecmglifpewnyaos")
    public suspend fun storageAccounts(`value`: List<StorageAccountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("enguljplxpleiiao")
    public suspend fun storageAccounts(argument: List<suspend StorageAccountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("lalyuirhwbsfqibq")
    public suspend fun storageAccounts(
        vararg
        argument: suspend StorageAccountArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("qakfgffyiqqpvopo")
    public suspend fun storageAccounts(argument: suspend StorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageAccountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param values The storage accounts for this resource.
     */
    @JvmName("fbmpvlsuskgaptde")
    public suspend fun storageAccounts(vararg values: StorageAccountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param value
     */
    @JvmName("ycwwqweykmpadcci")
    public suspend fun storageAuthentication(`value`: Either<String, StorageAuthentication>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAuthentication = mapped
    }

    /**
     * @param value
     */
    @JvmName("tpqtlcmjlgiqueac")
    public fun storageAuthentication(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAuthentication>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAuthentication = mapped
    }

    /**
     * @param value
     */
    @JvmName("hdnjcncxacjvyxds")
    public fun storageAuthentication(`value`: StorageAuthentication) {
        val toBeMapped = Either.ofRight<String, StorageAuthentication>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAuthentication = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qaamllwnhqmtnrtn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("eoedxpdbanpwjmxo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MediaServiceArgs = MediaServiceArgs(
        accountName = accountName,
        encryption = encryption,
        identity = identity,
        keyDelivery = keyDelivery,
        location = location,
        minimumTlsVersion = minimumTlsVersion,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        storageAccounts = storageAccounts,
        storageAuthentication = storageAuthentication,
        tags = tags,
    )
}
