@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.StreamingLocatorContentKeyResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.media.kotlin.outputs.StreamingLocatorContentKeyResponse.Companion.toKotlin as streamingLocatorContentKeyResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StreamingLocator].
 */
@PulumiTagMarker
public class StreamingLocatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StreamingLocatorArgs = StreamingLocatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StreamingLocatorArgsBuilder.() -> Unit) {
        val builder = StreamingLocatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StreamingLocator {
        val builtJavaResource = com.pulumi.azurenative.media.StreamingLocator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StreamingLocator(builtJavaResource)
    }
}

/**
 * A Streaming Locator resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2018-03-30-preview.
 * ## Example Usage
 * ### Creates a Streaming Locator with clear streaming
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingLocator = new AzureNative.Media.StreamingLocator("streamingLocator", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainier",
 *         ResourceGroupName = "contosorg",
 *         StreamingLocatorName = "UserCreatedClearStreamingLocator",
 *         StreamingPolicyName = "clearStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingLocator(ctx, "streamingLocator", &media.StreamingLocatorArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			AssetName:            pulumi.String("ClimbingMountRainier"),
 * 			ResourceGroupName:    pulumi.String("contosorg"),
 * 			StreamingLocatorName: pulumi.String("UserCreatedClearStreamingLocator"),
 * 			StreamingPolicyName:  pulumi.String("clearStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingLocator;
 * import com.pulumi.azurenative.media.StreamingLocatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingLocator = new StreamingLocator("streamingLocator", StreamingLocatorArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainier")
 *             .resourceGroupName("contosorg")
 *             .streamingLocatorName("UserCreatedClearStreamingLocator")
 *             .streamingPolicyName("clearStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Locator with secure streaming
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingLocator = new AzureNative.Media.StreamingLocator("streamingLocator", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainier",
 *         EndTime = "2028-12-31T23:59:59.9999999Z",
 *         ResourceGroupName = "contosorg",
 *         StartTime = "2018-03-01T00:00:00Z",
 *         StreamingLocatorName = "UserCreatedSecureStreamingLocator",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingLocator(ctx, "streamingLocator", &media.StreamingLocatorArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			AssetName:            pulumi.String("ClimbingMountRainier"),
 * 			EndTime:              pulumi.String("2028-12-31T23:59:59.9999999Z"),
 * 			ResourceGroupName:    pulumi.String("contosorg"),
 * 			StartTime:            pulumi.String("2018-03-01T00:00:00Z"),
 * 			StreamingLocatorName: pulumi.String("UserCreatedSecureStreamingLocator"),
 * 			StreamingPolicyName:  pulumi.String("UserCreatedSecureStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingLocator;
 * import com.pulumi.azurenative.media.StreamingLocatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingLocator = new StreamingLocator("streamingLocator", StreamingLocatorArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainier")
 *             .endTime("2028-12-31T23:59:59.9999999Z")
 *             .resourceGroupName("contosorg")
 *             .startTime("2018-03-01T00:00:00Z")
 *             .streamingLocatorName("UserCreatedSecureStreamingLocator")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Locator with user defined content keys
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingLocator = new AzureNative.Media.StreamingLocator("streamingLocator", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainier",
 *         ContentKeys = new[]
 *         {
 *             new AzureNative.Media.Inputs.StreamingLocatorContentKeyArgs
 *             {
 *                 Id = "60000000-0000-0000-0000-000000000001",
 *                 LabelReferenceInStreamingPolicy = "aesDefaultKey",
 *                 Value = "1UqLohAfWsEGkULYxHjYZg==",
 *             },
 *             new AzureNative.Media.Inputs.StreamingLocatorContentKeyArgs
 *             {
 *                 Id = "60000000-0000-0000-0000-000000000004",
 *                 LabelReferenceInStreamingPolicy = "cencDefaultKey",
 *                 Value = "4UqLohAfWsEGkULYxHjYZg==",
 *             },
 *             new AzureNative.Media.Inputs.StreamingLocatorContentKeyArgs
 *             {
 *                 Id = "60000000-0000-0000-0000-000000000007",
 *                 LabelReferenceInStreamingPolicy = "cbcsDefaultKey",
 *                 Value = "7UqLohAfWsEGkULYxHjYZg==",
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *         StreamingLocatorId = "90000000-0000-0000-0000-00000000000A",
 *         StreamingLocatorName = "UserCreatedSecureStreamingLocatorWithUserDefinedContentKeys",
 *         StreamingPolicyName = "secureStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingLocator(ctx, "streamingLocator", &media.StreamingLocatorArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			AssetName:   pulumi.String("ClimbingMountRainier"),
 * 			ContentKeys: []media.StreamingLocatorContentKeyArgs{
 * 				{
 * 					Id:                              pulumi.String("60000000-0000-0000-0000-000000000001"),
 * 					LabelReferenceInStreamingPolicy: pulumi.String("aesDefaultKey"),
 * 					Value:                           pulumi.String("1UqLohAfWsEGkULYxHjYZg=="),
 * 				},
 * 				{
 * 					Id:                              pulumi.String("60000000-0000-0000-0000-000000000004"),
 * 					LabelReferenceInStreamingPolicy: pulumi.String("cencDefaultKey"),
 * 					Value:                           pulumi.String("4UqLohAfWsEGkULYxHjYZg=="),
 * 				},
 * 				{
 * 					Id:                              pulumi.String("60000000-0000-0000-0000-000000000007"),
 * 					LabelReferenceInStreamingPolicy: pulumi.String("cbcsDefaultKey"),
 * 					Value:                           pulumi.String("7UqLohAfWsEGkULYxHjYZg=="),
 * 				},
 * 			},
 * 			ResourceGroupName:    pulumi.String("contosorg"),
 * 			StreamingLocatorId:   pulumi.String("90000000-0000-0000-0000-00000000000A"),
 * 			StreamingLocatorName: pulumi.String("UserCreatedSecureStreamingLocatorWithUserDefinedContentKeys"),
 * 			StreamingPolicyName:  pulumi.String("secureStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingLocator;
 * import com.pulumi.azurenative.media.StreamingLocatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingLocator = new StreamingLocator("streamingLocator", StreamingLocatorArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainier")
 *             .contentKeys(
 *                 Map.ofEntries(
 *                     Map.entry("id", "60000000-0000-0000-0000-000000000001"),
 *                     Map.entry("labelReferenceInStreamingPolicy", "aesDefaultKey"),
 *                     Map.entry("value", "1UqLohAfWsEGkULYxHjYZg==")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("id", "60000000-0000-0000-0000-000000000004"),
 *                     Map.entry("labelReferenceInStreamingPolicy", "cencDefaultKey"),
 *                     Map.entry("value", "4UqLohAfWsEGkULYxHjYZg==")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("id", "60000000-0000-0000-0000-000000000007"),
 *                     Map.entry("labelReferenceInStreamingPolicy", "cbcsDefaultKey"),
 *                     Map.entry("value", "7UqLohAfWsEGkULYxHjYZg==")
 *                 ))
 *             .resourceGroupName("contosorg")
 *             .streamingLocatorId("90000000-0000-0000-0000-00000000000A")
 *             .streamingLocatorName("UserCreatedSecureStreamingLocatorWithUserDefinedContentKeys")
 *             .streamingPolicyName("secureStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:StreamingLocator UserCreatedSecureStreamingLocatorWithUserDefinedContentKeys /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingLocators/{streamingLocatorName}
 * ```
 */
public class StreamingLocator internal constructor(
    override val javaResource: com.pulumi.azurenative.media.StreamingLocator,
) : KotlinCustomResource(javaResource, StreamingLocatorMapper) {
    /**
     * Alternative Media ID of this Streaming Locator
     */
    public val alternativeMediaId: Output<String>?
        get() = javaResource.alternativeMediaId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Asset Name
     */
    public val assetName: Output<String>
        get() = javaResource.assetName().applyValue({ args0 -> args0 })

    /**
     * The ContentKeys used by this Streaming Locator.
     */
    public val contentKeys: Output<List<StreamingLocatorContentKeyResponse>>?
        get() = javaResource.contentKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> streamingLocatorContentKeyResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The creation time of the Streaming Locator.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * Name of the default ContentKeyPolicy used by this Streaming Locator.
     */
    public val defaultContentKeyPolicyName: Output<String>?
        get() = javaResource.defaultContentKeyPolicyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The end time of the Streaming Locator.
     */
    public val endTime: Output<String>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of asset or account filters which apply to this streaming locator
     */
    public val filters: Output<List<String>>?
        get() = javaResource.filters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The start time of the Streaming Locator.
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The StreamingLocatorId of the Streaming Locator.
     */
    public val streamingLocatorId: Output<String>?
        get() = javaResource.streamingLocatorId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'
     */
    public val streamingPolicyName: Output<String>
        get() = javaResource.streamingPolicyName().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StreamingLocatorMapper : ResourceMapper<StreamingLocator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.StreamingLocator::class == javaResource::class

    override fun map(javaResource: Resource): StreamingLocator = StreamingLocator(
        javaResource as
            com.pulumi.azurenative.media.StreamingLocator,
    )
}

/**
 * @see [StreamingLocator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StreamingLocator].
 */
public suspend fun streamingLocator(
    name: String,
    block: suspend StreamingLocatorResourceBuilder.() -> Unit,
): StreamingLocator {
    val builder = StreamingLocatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StreamingLocator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun streamingLocator(name: String): StreamingLocator {
    val builder = StreamingLocatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
