@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.StreamingLocatorArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.StreamingLocatorContentKeyArgs
import com.pulumi.azurenative.media.kotlin.inputs.StreamingLocatorContentKeyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A Streaming Locator resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2018-03-30-preview.
 * ## Example Usage
 * ### Creates a Streaming Locator with clear streaming
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingLocator = new AzureNative.Media.StreamingLocator("streamingLocator", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainier",
 *         ResourceGroupName = "contosorg",
 *         StreamingLocatorName = "UserCreatedClearStreamingLocator",
 *         StreamingPolicyName = "clearStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingLocator(ctx, "streamingLocator", &media.StreamingLocatorArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			AssetName:            pulumi.String("ClimbingMountRainier"),
 * 			ResourceGroupName:    pulumi.String("contosorg"),
 * 			StreamingLocatorName: pulumi.String("UserCreatedClearStreamingLocator"),
 * 			StreamingPolicyName:  pulumi.String("clearStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingLocator;
 * import com.pulumi.azurenative.media.StreamingLocatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingLocator = new StreamingLocator("streamingLocator", StreamingLocatorArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainier")
 *             .resourceGroupName("contosorg")
 *             .streamingLocatorName("UserCreatedClearStreamingLocator")
 *             .streamingPolicyName("clearStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Locator with secure streaming
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingLocator = new AzureNative.Media.StreamingLocator("streamingLocator", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainier",
 *         EndTime = "2028-12-31T23:59:59.9999999Z",
 *         ResourceGroupName = "contosorg",
 *         StartTime = "2018-03-01T00:00:00Z",
 *         StreamingLocatorName = "UserCreatedSecureStreamingLocator",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingLocator(ctx, "streamingLocator", &media.StreamingLocatorArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			AssetName:            pulumi.String("ClimbingMountRainier"),
 * 			EndTime:              pulumi.String("2028-12-31T23:59:59.9999999Z"),
 * 			ResourceGroupName:    pulumi.String("contosorg"),
 * 			StartTime:            pulumi.String("2018-03-01T00:00:00Z"),
 * 			StreamingLocatorName: pulumi.String("UserCreatedSecureStreamingLocator"),
 * 			StreamingPolicyName:  pulumi.String("UserCreatedSecureStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingLocator;
 * import com.pulumi.azurenative.media.StreamingLocatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingLocator = new StreamingLocator("streamingLocator", StreamingLocatorArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainier")
 *             .endTime("2028-12-31T23:59:59.9999999Z")
 *             .resourceGroupName("contosorg")
 *             .startTime("2018-03-01T00:00:00Z")
 *             .streamingLocatorName("UserCreatedSecureStreamingLocator")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Locator with user defined content keys
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingLocator = new AzureNative.Media.StreamingLocator("streamingLocator", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainier",
 *         ContentKeys = new[]
 *         {
 *             new AzureNative.Media.Inputs.StreamingLocatorContentKeyArgs
 *             {
 *                 Id = "60000000-0000-0000-0000-000000000001",
 *                 LabelReferenceInStreamingPolicy = "aesDefaultKey",
 *                 Value = "1UqLohAfWsEGkULYxHjYZg==",
 *             },
 *             new AzureNative.Media.Inputs.StreamingLocatorContentKeyArgs
 *             {
 *                 Id = "60000000-0000-0000-0000-000000000004",
 *                 LabelReferenceInStreamingPolicy = "cencDefaultKey",
 *                 Value = "4UqLohAfWsEGkULYxHjYZg==",
 *             },
 *             new AzureNative.Media.Inputs.StreamingLocatorContentKeyArgs
 *             {
 *                 Id = "60000000-0000-0000-0000-000000000007",
 *                 LabelReferenceInStreamingPolicy = "cbcsDefaultKey",
 *                 Value = "7UqLohAfWsEGkULYxHjYZg==",
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *         StreamingLocatorId = "90000000-0000-0000-0000-00000000000A",
 *         StreamingLocatorName = "UserCreatedSecureStreamingLocatorWithUserDefinedContentKeys",
 *         StreamingPolicyName = "secureStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingLocator(ctx, "streamingLocator", &media.StreamingLocatorArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			AssetName:   pulumi.String("ClimbingMountRainier"),
 * 			ContentKeys: []media.StreamingLocatorContentKeyArgs{
 * 				{
 * 					Id:                              pulumi.String("60000000-0000-0000-0000-000000000001"),
 * 					LabelReferenceInStreamingPolicy: pulumi.String("aesDefaultKey"),
 * 					Value:                           pulumi.String("1UqLohAfWsEGkULYxHjYZg=="),
 * 				},
 * 				{
 * 					Id:                              pulumi.String("60000000-0000-0000-0000-000000000004"),
 * 					LabelReferenceInStreamingPolicy: pulumi.String("cencDefaultKey"),
 * 					Value:                           pulumi.String("4UqLohAfWsEGkULYxHjYZg=="),
 * 				},
 * 				{
 * 					Id:                              pulumi.String("60000000-0000-0000-0000-000000000007"),
 * 					LabelReferenceInStreamingPolicy: pulumi.String("cbcsDefaultKey"),
 * 					Value:                           pulumi.String("7UqLohAfWsEGkULYxHjYZg=="),
 * 				},
 * 			},
 * 			ResourceGroupName:    pulumi.String("contosorg"),
 * 			StreamingLocatorId:   pulumi.String("90000000-0000-0000-0000-00000000000A"),
 * 			StreamingLocatorName: pulumi.String("UserCreatedSecureStreamingLocatorWithUserDefinedContentKeys"),
 * 			StreamingPolicyName:  pulumi.String("secureStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingLocator;
 * import com.pulumi.azurenative.media.StreamingLocatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingLocator = new StreamingLocator("streamingLocator", StreamingLocatorArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainier")
 *             .contentKeys(
 *                 Map.ofEntries(
 *                     Map.entry("id", "60000000-0000-0000-0000-000000000001"),
 *                     Map.entry("labelReferenceInStreamingPolicy", "aesDefaultKey"),
 *                     Map.entry("value", "1UqLohAfWsEGkULYxHjYZg==")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("id", "60000000-0000-0000-0000-000000000004"),
 *                     Map.entry("labelReferenceInStreamingPolicy", "cencDefaultKey"),
 *                     Map.entry("value", "4UqLohAfWsEGkULYxHjYZg==")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("id", "60000000-0000-0000-0000-000000000007"),
 *                     Map.entry("labelReferenceInStreamingPolicy", "cbcsDefaultKey"),
 *                     Map.entry("value", "7UqLohAfWsEGkULYxHjYZg==")
 *                 ))
 *             .resourceGroupName("contosorg")
 *             .streamingLocatorId("90000000-0000-0000-0000-00000000000A")
 *             .streamingLocatorName("UserCreatedSecureStreamingLocatorWithUserDefinedContentKeys")
 *             .streamingPolicyName("secureStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:StreamingLocator UserCreatedSecureStreamingLocatorWithUserDefinedContentKeys /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingLocators/{streamingLocatorName}
 * ```
 * @property accountName The Media Services account name.
 * @property alternativeMediaId Alternative Media ID of this Streaming Locator
 * @property assetName Asset Name
 * @property contentKeys The ContentKeys used by this Streaming Locator.
 * @property defaultContentKeyPolicyName Name of the default ContentKeyPolicy used by this Streaming Locator.
 * @property endTime The end time of the Streaming Locator.
 * @property filters A list of asset or account filters which apply to this streaming locator
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property startTime The start time of the Streaming Locator.
 * @property streamingLocatorId The StreamingLocatorId of the Streaming Locator.
 * @property streamingLocatorName The Streaming Locator name.
 * @property streamingPolicyName Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'
 */
public data class StreamingLocatorArgs(
    public val accountName: Output<String>? = null,
    public val alternativeMediaId: Output<String>? = null,
    public val assetName: Output<String>? = null,
    public val contentKeys: Output<List<StreamingLocatorContentKeyArgs>>? = null,
    public val defaultContentKeyPolicyName: Output<String>? = null,
    public val endTime: Output<String>? = null,
    public val filters: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val streamingLocatorId: Output<String>? = null,
    public val streamingLocatorName: Output<String>? = null,
    public val streamingPolicyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.StreamingLocatorArgs> {
    override fun toJava(): com.pulumi.azurenative.media.StreamingLocatorArgs =
        com.pulumi.azurenative.media.StreamingLocatorArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .alternativeMediaId(alternativeMediaId?.applyValue({ args0 -> args0 }))
            .assetName(assetName?.applyValue({ args0 -> args0 }))
            .contentKeys(
                contentKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultContentKeyPolicyName(defaultContentKeyPolicyName?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .filters(filters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .streamingLocatorId(streamingLocatorId?.applyValue({ args0 -> args0 }))
            .streamingLocatorName(streamingLocatorName?.applyValue({ args0 -> args0 }))
            .streamingPolicyName(streamingPolicyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamingLocatorArgs].
 */
@PulumiTagMarker
public class StreamingLocatorArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var alternativeMediaId: Output<String>? = null

    private var assetName: Output<String>? = null

    private var contentKeys: Output<List<StreamingLocatorContentKeyArgs>>? = null

    private var defaultContentKeyPolicyName: Output<String>? = null

    private var endTime: Output<String>? = null

    private var filters: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var startTime: Output<String>? = null

    private var streamingLocatorId: Output<String>? = null

    private var streamingLocatorName: Output<String>? = null

    private var streamingPolicyName: Output<String>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("vgfewghdkonhpwup")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Alternative Media ID of this Streaming Locator
     */
    @JvmName("ecjehvkfocmkerig")
    public suspend fun alternativeMediaId(`value`: Output<String>) {
        this.alternativeMediaId = value
    }

    /**
     * @param value Asset Name
     */
    @JvmName("pyerkhauitmcbljt")
    public suspend fun assetName(`value`: Output<String>) {
        this.assetName = value
    }

    /**
     * @param value The ContentKeys used by this Streaming Locator.
     */
    @JvmName("dbtgjoplniormjwa")
    public suspend fun contentKeys(`value`: Output<List<StreamingLocatorContentKeyArgs>>) {
        this.contentKeys = value
    }

    @JvmName("bfmgpggyhfcarkjh")
    public suspend fun contentKeys(vararg values: Output<StreamingLocatorContentKeyArgs>) {
        this.contentKeys = Output.all(values.asList())
    }

    /**
     * @param values The ContentKeys used by this Streaming Locator.
     */
    @JvmName("bxhlgjwndjrvgfxc")
    public suspend fun contentKeys(values: List<Output<StreamingLocatorContentKeyArgs>>) {
        this.contentKeys = Output.all(values)
    }

    /**
     * @param value Name of the default ContentKeyPolicy used by this Streaming Locator.
     */
    @JvmName("ioitxnkqwycwktoa")
    public suspend fun defaultContentKeyPolicyName(`value`: Output<String>) {
        this.defaultContentKeyPolicyName = value
    }

    /**
     * @param value The end time of the Streaming Locator.
     */
    @JvmName("akyqwcsqbyecphnt")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value A list of asset or account filters which apply to this streaming locator
     */
    @JvmName("pgokcxjmupvhtxcw")
    public suspend fun filters(`value`: Output<List<String>>) {
        this.filters = value
    }

    @JvmName("unfefkrjrivrdmpb")
    public suspend fun filters(vararg values: Output<String>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values A list of asset or account filters which apply to this streaming locator
     */
    @JvmName("rwolnqhtattxauwl")
    public suspend fun filters(values: List<Output<String>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("ppwksvhsntsydnek")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The start time of the Streaming Locator.
     */
    @JvmName("ajbajfnxtwtiqlea")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The StreamingLocatorId of the Streaming Locator.
     */
    @JvmName("cpfaspdnmjpavmqe")
    public suspend fun streamingLocatorId(`value`: Output<String>) {
        this.streamingLocatorId = value
    }

    /**
     * @param value The Streaming Locator name.
     */
    @JvmName("wogxewrmwirpggob")
    public suspend fun streamingLocatorName(`value`: Output<String>) {
        this.streamingLocatorName = value
    }

    /**
     * @param value Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'
     */
    @JvmName("xsqmfdwsvqjcchrw")
    public suspend fun streamingPolicyName(`value`: Output<String>) {
        this.streamingPolicyName = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("womaagjnyyssfehy")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Alternative Media ID of this Streaming Locator
     */
    @JvmName("jynuqvastywlykjq")
    public suspend fun alternativeMediaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternativeMediaId = mapped
    }

    /**
     * @param value Asset Name
     */
    @JvmName("btiqiyvamfqprwrl")
    public suspend fun assetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetName = mapped
    }

    /**
     * @param value The ContentKeys used by this Streaming Locator.
     */
    @JvmName("fovitvqtbofmaoxi")
    public suspend fun contentKeys(`value`: List<StreamingLocatorContentKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentKeys = mapped
    }

    /**
     * @param argument The ContentKeys used by this Streaming Locator.
     */
    @JvmName("crjechlwcypxcfqr")
    public suspend
    fun contentKeys(argument: List<suspend StreamingLocatorContentKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StreamingLocatorContentKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.contentKeys = mapped
    }

    /**
     * @param argument The ContentKeys used by this Streaming Locator.
     */
    @JvmName("wynnujhyklangfcv")
    public suspend fun contentKeys(
        vararg
        argument: suspend StreamingLocatorContentKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StreamingLocatorContentKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.contentKeys = mapped
    }

    /**
     * @param argument The ContentKeys used by this Streaming Locator.
     */
    @JvmName("yegmvaxyiydkdlac")
    public suspend
    fun contentKeys(argument: suspend StreamingLocatorContentKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StreamingLocatorContentKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.contentKeys = mapped
    }

    /**
     * @param values The ContentKeys used by this Streaming Locator.
     */
    @JvmName("svhvcpkhittghjrd")
    public suspend fun contentKeys(vararg values: StreamingLocatorContentKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentKeys = mapped
    }

    /**
     * @param value Name of the default ContentKeyPolicy used by this Streaming Locator.
     */
    @JvmName("jbsemxpqjeiqnpsx")
    public suspend fun defaultContentKeyPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultContentKeyPolicyName = mapped
    }

    /**
     * @param value The end time of the Streaming Locator.
     */
    @JvmName("jcdyqsugwfhkegbk")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value A list of asset or account filters which apply to this streaming locator
     */
    @JvmName("wkrynorytgidpwii")
    public suspend fun filters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param values A list of asset or account filters which apply to this streaming locator
     */
    @JvmName("kdmkiwpmnhiaubgh")
    public suspend fun filters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("dujvswwileuhvtfu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The start time of the Streaming Locator.
     */
    @JvmName("fflaccttkuamavqx")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value The StreamingLocatorId of the Streaming Locator.
     */
    @JvmName("qpgxkiwpiwreovos")
    public suspend fun streamingLocatorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingLocatorId = mapped
    }

    /**
     * @param value The Streaming Locator name.
     */
    @JvmName("imrhxlxuevjbwqkb")
    public suspend fun streamingLocatorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingLocatorName = mapped
    }

    /**
     * @param value Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'
     */
    @JvmName("eatiiegobkagjoet")
    public suspend fun streamingPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingPolicyName = mapped
    }

    internal fun build(): StreamingLocatorArgs = StreamingLocatorArgs(
        accountName = accountName,
        alternativeMediaId = alternativeMediaId,
        assetName = assetName,
        contentKeys = contentKeys,
        defaultContentKeyPolicyName = defaultContentKeyPolicyName,
        endTime = endTime,
        filters = filters,
        resourceGroupName = resourceGroupName,
        startTime = startTime,
        streamingLocatorId = streamingLocatorId,
        streamingLocatorName = streamingLocatorName,
        streamingPolicyName = streamingPolicyName,
    )
}
