@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Track].
 */
@PulumiTagMarker
public class TrackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrackArgs = TrackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrackArgsBuilder.() -> Unit) {
        val builder = TrackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Track {
        val builtJavaResource = com.pulumi.azurenative.media.Track(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Track(builtJavaResource)
    }
}

/**
 * An Asset Track resource.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-11-01.
 * ## Example Usage
 * ### Creates a Track
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var track = new AzureNative.Media.Track("track", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainer",
 *         ResourceGroupName = "contosorg",
 *         Track = new AzureNative.Media.Inputs.TextTrackArgs
 *         {
 *             DisplayName = "A new track",
 *             FileName = "text3.ttml",
 *             OdataType = "#Microsoft.Media.TextTrack",
 *             PlayerVisibility = "Visible",
 *         },
 *         TrackName = "text3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewTrack(ctx, "track", &media.TrackArgs{
 * 			AccountName:       pulumi.String("contosomedia"),
 * 			AssetName:         pulumi.String("ClimbingMountRainer"),
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			Track: media.TextTrack{
 * 				DisplayName:      "A new track",
 * 				FileName:         "text3.ttml",
 * 				OdataType:        "#Microsoft.Media.TextTrack",
 * 				PlayerVisibility: "Visible",
 * 			},
 * 			TrackName: pulumi.String("text3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Track;
 * import com.pulumi.azurenative.media.TrackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var track = new Track("track", TrackArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainer")
 *             .resourceGroupName("contosorg")
 *             .track(Map.ofEntries(
 *                 Map.entry("displayName", "A new track"),
 *                 Map.entry("fileName", "text3.ttml"),
 *                 Map.entry("odataType", "#Microsoft.Media.TextTrack"),
 *                 Map.entry("playerVisibility", "Visible")
 *             ))
 *             .trackName("text3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:Track text3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}/tracks/{trackName}
 * ```
 */
public class Track internal constructor(
    override val javaResource: com.pulumi.azurenative.media.Track,
) : KotlinCustomResource(javaResource, TrackMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the asset track.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Detailed information about a track in the asset.
     */
    public val track: Output<Any>?
        get() = javaResource.track().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TrackMapper : ResourceMapper<Track> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.Track::class == javaResource::class

    override fun map(javaResource: Resource): Track = Track(
        javaResource as
            com.pulumi.azurenative.media.Track,
    )
}

/**
 * @see [Track].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Track].
 */
public suspend fun track(name: String, block: suspend TrackResourceBuilder.() -> Unit): Track {
    val builder = TrackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Track].
 * @param name The _unique_ name of the resulting resource.
 */
public fun track(name: String): Track {
    val builder = TrackResourceBuilder()
    builder.name(name)
    return builder.build()
}
