@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
 */
public enum class ChannelMapping(
    public val javaValue: com.pulumi.azurenative.media.enums.ChannelMapping,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.ChannelMapping> {
    /**
     * The Front Left Channel.
     */
    FrontLeft(com.pulumi.azurenative.media.enums.ChannelMapping.FrontLeft),

    /**
     * The Front Right Channel.
     */
    FrontRight(com.pulumi.azurenative.media.enums.ChannelMapping.FrontRight),

    /**
     * The Center Channel.
     */
    Center(com.pulumi.azurenative.media.enums.ChannelMapping.Center),

    /**
     * Low Frequency Effects Channel.  Sometimes referred to as the subwoofer.
     */
    LowFrequencyEffects(com.pulumi.azurenative.media.enums.ChannelMapping.LowFrequencyEffects),

    /**
     * The Back Left Channel.  Sometimes referred to as the Left Surround Channel.
     */
    BackLeft(com.pulumi.azurenative.media.enums.ChannelMapping.BackLeft),

    /**
     * The Back Right Channel.  Sometimes referred to as the Right Surround Channel.
     */
    BackRight(com.pulumi.azurenative.media.enums.ChannelMapping.BackRight),

    /**
     * The Left Stereo channel.  Sometimes referred to as Down Mix Left.
     */
    StereoLeft(com.pulumi.azurenative.media.enums.ChannelMapping.StereoLeft),

    /**
     * The Right Stereo channel.  Sometimes referred to as Down Mix Right.
     */
    StereoRight(com.pulumi.azurenative.media.enums.ChannelMapping.StereoRight),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.ChannelMapping = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.ChannelMapping): ChannelMapping =
            ChannelMapping.values().first { it.javaValue == javaType }
    }
}
