@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
 */
public enum class FaceRedactorMode(
    public val javaValue: com.pulumi.azurenative.media.enums.FaceRedactorMode,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.FaceRedactorMode> {
    /**
     * Analyze mode detects faces and outputs a metadata file with the results. Allows editing of the metadata file before faces are blurred with Redact mode.
     */
    Analyze(com.pulumi.azurenative.media.enums.FaceRedactorMode.Analyze),

    /**
     * Redact mode consumes the metadata file from Analyze mode and redacts the faces found.
     */
    Redact(com.pulumi.azurenative.media.enums.FaceRedactorMode.Redact),

    /**
     * Combined mode does the Analyze and Redact steps in one pass when editing the analyzed faces is not desired.
     */
    Combined(com.pulumi.azurenative.media.enums.FaceRedactorMode.Combined),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.FaceRedactorMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.FaceRedactorMode):
            FaceRedactorMode = FaceRedactorMode.values().first { it.javaValue == javaType }
    }
}
