@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * We currently support Main. Default is Auto.
 */
public enum class H265VideoProfile(
    public val javaValue: com.pulumi.azurenative.media.enums.H265VideoProfile,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.H265VideoProfile> {
    /**
     * Tells the encoder to automatically determine the appropriate H.265 profile.
     */
    Auto(com.pulumi.azurenative.media.enums.H265VideoProfile.Auto),

    /**
     * Main profile (https://x265.readthedocs.io/en/default/cli.html?highlight=profile#profile-level-tier)
     */
    Main(com.pulumi.azurenative.media.enums.H265VideoProfile.Main),

    /**
     * Main 10 profile (https://en.wikipedia.org/wiki/High_Efficiency_Video_Coding#Main_10)
     */
    Main10(com.pulumi.azurenative.media.enums.H265VideoProfile.Main10),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.H265VideoProfile = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.H265VideoProfile):
            H265VideoProfile = H265VideoProfile.values().first { it.javaValue == javaType }
    }
}
