@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out.
 */
public enum class InsightsType(
    public val javaValue: com.pulumi.azurenative.media.enums.InsightsType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.InsightsType> {
    /**
     * Generate audio only insights. Ignore video even if present. Fails if no audio is present.
     */
    AudioInsightsOnly(com.pulumi.azurenative.media.enums.InsightsType.AudioInsightsOnly),

    /**
     * Generate video only insights. Ignore audio if present. Fails if no video is present.
     */
    VideoInsightsOnly(com.pulumi.azurenative.media.enums.InsightsType.VideoInsightsOnly),

    /**
     * Generate both audio and video insights. Fails if either audio or video Insights fail.
     */
    AllInsights(com.pulumi.azurenative.media.enums.InsightsType.AllInsights),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.InsightsType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.InsightsType): InsightsType =
            InsightsType.values().first { it.javaValue == javaType }
    }
}
