@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Underlying RTSP transport. This can be used to enable or disable HTTP tunneling.
 */
public enum class MediaGraphRtspTransport(
    public val javaValue: com.pulumi.azurenative.media.enums.MediaGraphRtspTransport,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.MediaGraphRtspTransport> {
    /**
     * HTTP/HTTPS transport. This should be used when HTTP tunneling is desired.
     */
    Http(com.pulumi.azurenative.media.enums.MediaGraphRtspTransport.Http),

    /**
     * TCP transport. This should be used when HTTP tunneling is not desired.
     */
    Tcp(com.pulumi.azurenative.media.enums.MediaGraphRtspTransport.Tcp),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.MediaGraphRtspTransport = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.MediaGraphRtspTransport):
            MediaGraphRtspTransport =
            MediaGraphRtspTransport.values().first { it.javaValue == javaType }
    }
}
