@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not public network access is allowed for resources under the Media Services account.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.media.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.PublicNetworkAccess> {
    /**
     * Public network access is enabled.
     */
    Enabled(com.pulumi.azurenative.media.enums.PublicNetworkAccess.Enabled),

    /**
     * Public network access is disabled.
     */
    Disabled(com.pulumi.azurenative.media.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
