@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
 */
public enum class Rotation(
    public val javaValue: com.pulumi.azurenative.media.enums.Rotation,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.Rotation> {
    /**
     * Automatically detect and rotate as needed.
     */
    Auto(com.pulumi.azurenative.media.enums.Rotation.Auto),

    /**
     * Do not rotate the video.  If the output format supports it, any metadata about rotation is kept intact.
     */
    None(com.pulumi.azurenative.media.enums.Rotation.None),

    /**
     * Do not rotate the video but remove any metadata about the rotation.
     */
    Rotate0(com.pulumi.azurenative.media.enums.Rotation.Rotate0),

    /**
     * Rotate 90 degrees clockwise.
     */
    Rotate90(com.pulumi.azurenative.media.enums.Rotation.Rotate90),

    /**
     * Rotate 180 degrees clockwise.
     */
    Rotate180(com.pulumi.azurenative.media.enums.Rotation.Rotate180),

    /**
     * Rotate 270 degrees clockwise.
     */
    Rotate270(com.pulumi.azurenative.media.enums.Rotation.Rotate270),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.Rotation = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.Rotation): Rotation =
            Rotation.values().first { it.javaValue == javaType }
    }
}
