@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 */
public enum class StretchMode(
    public val javaValue: com.pulumi.azurenative.media.enums.StretchMode,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.StretchMode> {
    /**
     * Strictly respect the output resolution without considering the pixel aspect ratio or display aspect ratio of the input video.
     */
    None(com.pulumi.azurenative.media.enums.StretchMode.None),

    /**
     * Override the output resolution, and change it to match the display aspect ratio of the input, without padding. For example, if the input is 1920x1080 and the encoding preset asks for 1280x1280, then the value in the preset is overridden, and the output will be at 1280x720, which maintains the input aspect ratio of 16:9.
     */
    AutoSize(com.pulumi.azurenative.media.enums.StretchMode.AutoSize),

    /**
     * Pad the output (with either letterbox or pillar box) to honor the output resolution, while ensuring that the active video region in the output has the same aspect ratio as the input. For example, if the input is 1920x1080 and the encoding preset asks for 1280x1280, then the output will be at 1280x1280, which contains an inner rectangle of 1280x720 at aspect ratio of 16:9, and pillar box regions 280 pixels wide at the left and right.
     */
    AutoFit(com.pulumi.azurenative.media.enums.StretchMode.AutoFit),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.StretchMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.StretchMode): StretchMode =
            StretchMode.values().first { it.javaValue == javaType }
    }
}
