@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The TrackAttribute to filter the tracks by.
 */
public enum class TrackAttribute(
    public val javaValue: com.pulumi.azurenative.media.enums.TrackAttribute,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.TrackAttribute> {
    /**
     * The bitrate of the track.
     */
    Bitrate(com.pulumi.azurenative.media.enums.TrackAttribute.Bitrate),

    /**
     * The language of the track.
     */
    Language(com.pulumi.azurenative.media.enums.TrackAttribute.Language),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.TrackAttribute = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.TrackAttribute): TrackAttribute =
            TrackAttribute.values().first { it.javaValue == javaType }
    }
}
