@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AccountEncryptionArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.AccountEncryptionKeyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property identity The Key Vault identity.
 * @property keyVaultProperties The properties of the key used to encrypt the account.
 * @property type The type of key used to encrypt the Account Key.
 */
public data class AccountEncryptionArgs(
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
    public val type: Output<Either<String, AccountEncryptionKeyType>>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.AccountEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.AccountEncryptionArgs =
        com.pulumi.azurenative.media.inputs.AccountEncryptionArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccountEncryptionArgs].
 */
@PulumiTagMarker
public class AccountEncryptionArgsBuilder internal constructor() {
    private var identity: Output<ResourceIdentityArgs>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    private var type: Output<Either<String, AccountEncryptionKeyType>>? = null

    /**
     * @param value The Key Vault identity.
     */
    @JvmName("mekwtgwiktpkfnma")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The properties of the key used to encrypt the account.
     */
    @JvmName("kpbucyiegltaoqaq")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value The type of key used to encrypt the Account Key.
     */
    @JvmName("dkbdwjxkukwnnjov")
    public suspend fun type(`value`: Output<Either<String, AccountEncryptionKeyType>>) {
        this.type = value
    }

    /**
     * @param value The Key Vault identity.
     */
    @JvmName("ifjvrqcxmrgxurax")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The Key Vault identity.
     */
    @JvmName("rucnqedtxsqqouke")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The properties of the key used to encrypt the account.
     */
    @JvmName("bkblrpsuhmbfgaso")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument The properties of the key used to encrypt the account.
     */
    @JvmName("wjnacooyvxoprdxd")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value The type of key used to encrypt the Account Key.
     */
    @JvmName("ccfgohfjyksruxjk")
    public suspend fun type(`value`: Either<String, AccountEncryptionKeyType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of key used to encrypt the Account Key.
     */
    @JvmName("fdpyivocyyirkhix")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccountEncryptionKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of key used to encrypt the Account Key.
     */
    @JvmName("rnpauwvlqrckckft")
    public fun type(`value`: AccountEncryptionKeyType) {
        val toBeMapped = Either.ofRight<String, AccountEncryptionKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AccountEncryptionArgs = AccountEncryptionArgs(
        identity = identity,
        keyVaultProperties = keyVaultProperties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
