@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AudioAnalyzerPresetArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.AudioAnalysisMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.
 * @property audioLanguage The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
 * @property experimentalOptions Dictionary containing key value pairs for parameters not exposed in the preset itself
 * @property mode Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
 */
public data class AudioAnalyzerPresetArgs(
    public val audioLanguage: Output<String>? = null,
    public val experimentalOptions: Output<Map<String, String>>? = null,
    public val mode: Output<Either<String, AudioAnalysisMode>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.AudioAnalyzerPresetArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.AudioAnalyzerPresetArgs =
        com.pulumi.azurenative.media.inputs.AudioAnalyzerPresetArgs.builder()
            .audioLanguage(audioLanguage?.applyValue({ args0 -> args0 }))
            .experimentalOptions(
                experimentalOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AudioAnalyzerPresetArgs].
 */
@PulumiTagMarker
public class AudioAnalyzerPresetArgsBuilder internal constructor() {
    private var audioLanguage: Output<String>? = null

    private var experimentalOptions: Output<Map<String, String>>? = null

    private var mode: Output<Either<String, AudioAnalysisMode>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
     */
    @JvmName("ynunhwjvengfmdnt")
    public suspend fun audioLanguage(`value`: Output<String>) {
        this.audioLanguage = value
    }

    /**
     * @param value Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("mvdirccsyriojsye")
    public suspend fun experimentalOptions(`value`: Output<Map<String, String>>) {
        this.experimentalOptions = value
    }

    /**
     * @param value Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
     */
    @JvmName("jpyhddvnhbparvwl")
    public suspend fun mode(`value`: Output<Either<String, AudioAnalysisMode>>) {
        this.mode = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
     */
    @JvmName("okrxxhwjkgwvmntr")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
     */
    @JvmName("wwulcohdpwhgwaku")
    public suspend fun audioLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioLanguage = mapped
    }

    /**
     * @param value Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("pqncuwdudfdumekf")
    public suspend fun experimentalOptions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentalOptions = mapped
    }

    /**
     * @param values Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("wynokajkjympvncb")
    public fun experimentalOptions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.experimentalOptions = mapped
    }

    /**
     * @param value Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
     */
    @JvmName("geadrtcpksywvuew")
    public suspend fun mode(`value`: Either<String, AudioAnalysisMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
     */
    @JvmName("oivlhunsofdogane")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AudioAnalysisMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
     */
    @JvmName("cqcnskwfkhnqjxne")
    public fun mode(`value`: AudioAnalysisMode) {
        val toBeMapped = Either.ofRight<String, AudioAnalysisMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
     */
    @JvmName("eouhpigpwepbomxn")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): AudioAnalyzerPresetArgs = AudioAnalyzerPresetArgs(
        audioLanguage = audioLanguage,
        experimentalOptions = experimentalOptions,
        mode = mode,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
