@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class for CommonEncryptionCbcs encryption scheme
 * @property clearKeyEncryptionConfiguration Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
 * @property clearTracks Representing which tracks should not be encrypted
 * @property contentKeys Representing default content key for each encryption scheme and separate content keys for specific tracks
 * @property drm Configuration of DRMs for current encryption scheme
 * @property enabledProtocols Representing supported protocols
 */
public data class CommonEncryptionCbcsArgs(
    public val clearKeyEncryptionConfiguration: Output<ClearKeyEncryptionConfigurationArgs>? = null,
    public val clearTracks: Output<List<TrackSelectionArgs>>? = null,
    public val contentKeys: Output<StreamingPolicyContentKeysArgs>? = null,
    public val drm: Output<CbcsDrmConfigurationArgs>? = null,
    public val enabledProtocols: Output<EnabledProtocolsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs =
        com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs.builder()
            .clearKeyEncryptionConfiguration(
                clearKeyEncryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .clearTracks(
                clearTracks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .contentKeys(contentKeys?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .drm(drm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabledProtocols(
                enabledProtocols?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CommonEncryptionCbcsArgs].
 */
@PulumiTagMarker
public class CommonEncryptionCbcsArgsBuilder internal constructor() {
    private var clearKeyEncryptionConfiguration: Output<ClearKeyEncryptionConfigurationArgs>? = null

    private var clearTracks: Output<List<TrackSelectionArgs>>? = null

    private var contentKeys: Output<StreamingPolicyContentKeysArgs>? = null

    private var drm: Output<CbcsDrmConfigurationArgs>? = null

    private var enabledProtocols: Output<EnabledProtocolsArgs>? = null

    /**
     * @param value Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
     */
    @JvmName("krvcolokywynjlcx")
    public suspend
    fun clearKeyEncryptionConfiguration(`value`: Output<ClearKeyEncryptionConfigurationArgs>) {
        this.clearKeyEncryptionConfiguration = value
    }

    /**
     * @param value Representing which tracks should not be encrypted
     */
    @JvmName("idokdtusfyylcqfg")
    public suspend fun clearTracks(`value`: Output<List<TrackSelectionArgs>>) {
        this.clearTracks = value
    }

    @JvmName("suaiknmghavrghwb")
    public suspend fun clearTracks(vararg values: Output<TrackSelectionArgs>) {
        this.clearTracks = Output.all(values.asList())
    }

    /**
     * @param values Representing which tracks should not be encrypted
     */
    @JvmName("cpighxsqiwiyxwua")
    public suspend fun clearTracks(values: List<Output<TrackSelectionArgs>>) {
        this.clearTracks = Output.all(values)
    }

    /**
     * @param value Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("botxuleogxktwexf")
    public suspend fun contentKeys(`value`: Output<StreamingPolicyContentKeysArgs>) {
        this.contentKeys = value
    }

    /**
     * @param value Configuration of DRMs for current encryption scheme
     */
    @JvmName("mmyljxyqekwvdsag")
    public suspend fun drm(`value`: Output<CbcsDrmConfigurationArgs>) {
        this.drm = value
    }

    /**
     * @param value Representing supported protocols
     */
    @JvmName("rpcomuwdrsryugkm")
    public suspend fun enabledProtocols(`value`: Output<EnabledProtocolsArgs>) {
        this.enabledProtocols = value
    }

    /**
     * @param value Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
     */
    @JvmName("qwxhtgfpwdhvtwpr")
    public suspend
    fun clearKeyEncryptionConfiguration(`value`: ClearKeyEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clearKeyEncryptionConfiguration = mapped
    }

    /**
     * @param argument Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
     */
    @JvmName("afwtvkdhmexynkeg")
    public suspend
    fun clearKeyEncryptionConfiguration(argument: suspend ClearKeyEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClearKeyEncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clearKeyEncryptionConfiguration = mapped
    }

    /**
     * @param value Representing which tracks should not be encrypted
     */
    @JvmName("frsdotihubypawbi")
    public suspend fun clearTracks(`value`: List<TrackSelectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("dllgsekhtgymtlkc")
    public suspend fun clearTracks(argument: List<suspend TrackSelectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("apvyhdhvexbpelra")
    public suspend fun clearTracks(vararg argument: suspend TrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("icdwpetepvquqoti")
    public suspend fun clearTracks(argument: suspend TrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrackSelectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param values Representing which tracks should not be encrypted
     */
    @JvmName("cnnjhkmabdkhahqy")
    public suspend fun clearTracks(vararg values: TrackSelectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clearTracks = mapped
    }

    /**
     * @param value Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("drthcqvwjptqjwac")
    public suspend fun contentKeys(`value`: StreamingPolicyContentKeysArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentKeys = mapped
    }

    /**
     * @param argument Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("oygkygloqenxneqk")
    public suspend
    fun contentKeys(argument: suspend StreamingPolicyContentKeysArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingPolicyContentKeysArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentKeys = mapped
    }

    /**
     * @param value Configuration of DRMs for current encryption scheme
     */
    @JvmName("vpjbjndttflvcrnw")
    public suspend fun drm(`value`: CbcsDrmConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drm = mapped
    }

    /**
     * @param argument Configuration of DRMs for current encryption scheme
     */
    @JvmName("rxghypojymjoawtk")
    public suspend fun drm(argument: suspend CbcsDrmConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CbcsDrmConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.drm = mapped
    }

    /**
     * @param value Representing supported protocols
     */
    @JvmName("mvsjcmvnrolttseb")
    public suspend fun enabledProtocols(`value`: EnabledProtocolsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledProtocols = mapped
    }

    /**
     * @param argument Representing supported protocols
     */
    @JvmName("qfelmyysmnulkhan")
    public suspend fun enabledProtocols(argument: suspend EnabledProtocolsArgsBuilder.() -> Unit) {
        val toBeMapped = EnabledProtocolsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enabledProtocols = mapped
    }

    internal fun build(): CommonEncryptionCbcsArgs = CommonEncryptionCbcsArgs(
        clearKeyEncryptionConfiguration = clearKeyEncryptionConfiguration,
        clearTracks = clearTracks,
        contentKeys = contentKeys,
        drm = drm,
        enabledProtocols = enabledProtocols,
    )
}
