@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a policy option.
 * @property configuration The key delivery configuration.
 * @property name The Policy Option description.
 * @property restriction The requirements that must be met to deliver keys with this configuration
 */
public data class ContentKeyPolicyOptionArgs(
    public val configuration: Output<Any>,
    public val name: Output<String>? = null,
    public val restriction: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyOptionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyOptionArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyOptionArgs.builder()
            .configuration(configuration.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .restriction(restriction.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyOptionArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyOptionArgsBuilder internal constructor() {
    private var configuration: Output<Any>? = null

    private var name: Output<String>? = null

    private var restriction: Output<Any>? = null

    /**
     * @param value The key delivery configuration.
     */
    @JvmName("kanoxfwwanfqqamj")
    public suspend fun configuration(`value`: Output<Any>) {
        this.configuration = value
    }

    /**
     * @param value The Policy Option description.
     */
    @JvmName("ndksynfmifhkyxjq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The requirements that must be met to deliver keys with this configuration
     */
    @JvmName("pontgevrvrdqywqg")
    public suspend fun restriction(`value`: Output<Any>) {
        this.restriction = value
    }

    /**
     * @param value The key delivery configuration.
     */
    @JvmName("onjjjlpdugjdjgaq")
    public suspend fun configuration(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value The Policy Option description.
     */
    @JvmName("mrtwtjxyxnemcgfg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The requirements that must be met to deliver keys with this configuration
     */
    @JvmName("yllhmdbtrarppuym")
    public suspend fun restriction(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restriction = mapped
    }

    internal fun build(): ContentKeyPolicyOptionArgs = ContentKeyPolicyOptionArgs(
        configuration = configuration ?: throw PulumiNullFieldException("configuration"),
        name = name,
        restriction = restriction ?: throw PulumiNullFieldException("restriction"),
    )
}
