@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies a configuration for PlayReady licenses.
 * @property licenses The PlayReady licenses.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
 * @property responseCustomData The custom response data.
 */
public data class ContentKeyPolicyPlayReadyConfigurationArgs(
    public val licenses: Output<List<ContentKeyPolicyPlayReadyLicenseArgs>>,
    public val odataType: Output<String>,
    public val responseCustomData: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyConfigurationArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyConfigurationArgs.builder()
            .licenses(
                licenses.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .responseCustomData(responseCustomData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyPlayReadyConfigurationArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyPlayReadyConfigurationArgsBuilder internal constructor() {
    private var licenses: Output<List<ContentKeyPolicyPlayReadyLicenseArgs>>? = null

    private var odataType: Output<String>? = null

    private var responseCustomData: Output<String>? = null

    /**
     * @param value The PlayReady licenses.
     */
    @JvmName("gjwmuydjxsylaurg")
    public suspend fun licenses(`value`: Output<List<ContentKeyPolicyPlayReadyLicenseArgs>>) {
        this.licenses = value
    }

    @JvmName("hyjxnjpnnmiwbwge")
    public suspend fun licenses(vararg values: Output<ContentKeyPolicyPlayReadyLicenseArgs>) {
        this.licenses = Output.all(values.asList())
    }

    /**
     * @param values The PlayReady licenses.
     */
    @JvmName("winiqtpaypnuuiwo")
    public suspend fun licenses(values: List<Output<ContentKeyPolicyPlayReadyLicenseArgs>>) {
        this.licenses = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
     */
    @JvmName("yklvslxyyodkpwrp")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The custom response data.
     */
    @JvmName("jrdxbyvpowcngihs")
    public suspend fun responseCustomData(`value`: Output<String>) {
        this.responseCustomData = value
    }

    /**
     * @param value The PlayReady licenses.
     */
    @JvmName("cvpdgxvhgrmtuxcp")
    public suspend fun licenses(`value`: List<ContentKeyPolicyPlayReadyLicenseArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenses = mapped
    }

    /**
     * @param argument The PlayReady licenses.
     */
    @JvmName("ctqjyasguxxtfdeu")
    public suspend
    fun licenses(argument: List<suspend ContentKeyPolicyPlayReadyLicenseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContentKeyPolicyPlayReadyLicenseArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.licenses = mapped
    }

    /**
     * @param argument The PlayReady licenses.
     */
    @JvmName("kycdqhwsquckmenu")
    public suspend fun licenses(
        vararg
        argument: suspend ContentKeyPolicyPlayReadyLicenseArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContentKeyPolicyPlayReadyLicenseArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.licenses = mapped
    }

    /**
     * @param argument The PlayReady licenses.
     */
    @JvmName("enkiyoqhcjbvevio")
    public suspend
    fun licenses(argument: suspend ContentKeyPolicyPlayReadyLicenseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContentKeyPolicyPlayReadyLicenseArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.licenses = mapped
    }

    /**
     * @param values The PlayReady licenses.
     */
    @JvmName("yctbaomxwmhdumam")
    public suspend fun licenses(vararg values: ContentKeyPolicyPlayReadyLicenseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenses = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
     */
    @JvmName("ylknpcxtficjpseq")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The custom response data.
     */
    @JvmName("joimgmrujavvioca")
    public suspend fun responseCustomData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCustomData = mapped
    }

    internal fun build(): ContentKeyPolicyPlayReadyConfigurationArgs =
        ContentKeyPolicyPlayReadyConfigurationArgs(
            licenses = licenses ?: throw PulumiNullFieldException("licenses"),
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
            responseCustomData = responseCustomData,
        )
}
