@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyUnknownRestrictionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
 */
public data class ContentKeyPolicyUnknownRestrictionArgs(
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyUnknownRestrictionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyUnknownRestrictionArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyUnknownRestrictionArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyUnknownRestrictionArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyUnknownRestrictionArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
     */
    @JvmName("ncsvxcjvcimoiohj")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
     */
    @JvmName("rvpplncbdyrbrxsy")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ContentKeyPolicyUnknownRestrictionArgs =
        ContentKeyPolicyUnknownRestrictionArgs(
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        )
}
