@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.CrossSiteAccessPoliciesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The client access policy.
 * @property clientAccessPolicy The content of clientaccesspolicy.xml used by Silverlight.
 * @property crossDomainPolicy The content of crossdomain.xml used by Silverlight.
 */
public data class CrossSiteAccessPoliciesArgs(
    public val clientAccessPolicy: Output<String>? = null,
    public val crossDomainPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.CrossSiteAccessPoliciesArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.CrossSiteAccessPoliciesArgs =
        com.pulumi.azurenative.media.inputs.CrossSiteAccessPoliciesArgs.builder()
            .clientAccessPolicy(clientAccessPolicy?.applyValue({ args0 -> args0 }))
            .crossDomainPolicy(crossDomainPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrossSiteAccessPoliciesArgs].
 */
@PulumiTagMarker
public class CrossSiteAccessPoliciesArgsBuilder internal constructor() {
    private var clientAccessPolicy: Output<String>? = null

    private var crossDomainPolicy: Output<String>? = null

    /**
     * @param value The content of clientaccesspolicy.xml used by Silverlight.
     */
    @JvmName("fllccrfbjtqvpjxb")
    public suspend fun clientAccessPolicy(`value`: Output<String>) {
        this.clientAccessPolicy = value
    }

    /**
     * @param value The content of crossdomain.xml used by Silverlight.
     */
    @JvmName("xuflnlpkwphcdmss")
    public suspend fun crossDomainPolicy(`value`: Output<String>) {
        this.crossDomainPolicy = value
    }

    /**
     * @param value The content of clientaccesspolicy.xml used by Silverlight.
     */
    @JvmName("mowpibkptxcdevqy")
    public suspend fun clientAccessPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAccessPolicy = mapped
    }

    /**
     * @param value The content of crossdomain.xml used by Silverlight.
     */
    @JvmName("fvbblvfyjjowyjuo")
    public suspend fun crossDomainPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossDomainPolicy = mapped
    }

    internal fun build(): CrossSiteAccessPoliciesArgs = CrossSiteAccessPoliciesArgs(
        clientAccessPolicy = clientAccessPolicy,
        crossDomainPolicy = crossDomainPolicy,
    )
}
