@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.DeinterlaceArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.DeinterlaceMode
import com.pulumi.azurenative.media.kotlin.enums.DeinterlaceParity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the de-interlacing settings.
 * @property mode The deinterlacing mode. Defaults to AutoPixelAdaptive.
 * @property parity The field parity for de-interlacing, defaults to Auto.
 */
public data class DeinterlaceArgs(
    public val mode: Output<Either<String, DeinterlaceMode>>? = null,
    public val parity: Output<Either<String, DeinterlaceParity>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.DeinterlaceArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.DeinterlaceArgs =
        com.pulumi.azurenative.media.inputs.DeinterlaceArgs.builder()
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parity(
                parity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeinterlaceArgs].
 */
@PulumiTagMarker
public class DeinterlaceArgsBuilder internal constructor() {
    private var mode: Output<Either<String, DeinterlaceMode>>? = null

    private var parity: Output<Either<String, DeinterlaceParity>>? = null

    /**
     * @param value The deinterlacing mode. Defaults to AutoPixelAdaptive.
     */
    @JvmName("yenqkmrbomwgkrhr")
    public suspend fun mode(`value`: Output<Either<String, DeinterlaceMode>>) {
        this.mode = value
    }

    /**
     * @param value The field parity for de-interlacing, defaults to Auto.
     */
    @JvmName("yvvwhielglpvldau")
    public suspend fun parity(`value`: Output<Either<String, DeinterlaceParity>>) {
        this.parity = value
    }

    /**
     * @param value The deinterlacing mode. Defaults to AutoPixelAdaptive.
     */
    @JvmName("qbwwuadybvcasfjj")
    public suspend fun mode(`value`: Either<String, DeinterlaceMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The deinterlacing mode. Defaults to AutoPixelAdaptive.
     */
    @JvmName("hwxmlfitnotugbfk")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeinterlaceMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The deinterlacing mode. Defaults to AutoPixelAdaptive.
     */
    @JvmName("nakqwpypckcrlkhu")
    public fun mode(`value`: DeinterlaceMode) {
        val toBeMapped = Either.ofRight<String, DeinterlaceMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The field parity for de-interlacing, defaults to Auto.
     */
    @JvmName("mnlpndubowfniasl")
    public suspend fun parity(`value`: Either<String, DeinterlaceParity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parity = mapped
    }

    /**
     * @param value The field parity for de-interlacing, defaults to Auto.
     */
    @JvmName("lxnxtfyjiwlvyjbt")
    public fun parity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeinterlaceParity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parity = mapped
    }

    /**
     * @param value The field parity for de-interlacing, defaults to Auto.
     */
    @JvmName("wnpbcmeklraoceav")
    public fun parity(`value`: DeinterlaceParity) {
        val toBeMapped = Either.ofRight<String, DeinterlaceParity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parity = mapped
    }

    internal fun build(): DeinterlaceArgs = DeinterlaceArgs(
        mode = mode,
        parity = parity,
    )
}
