@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class to specify which protocols are enabled
 * @property dash Enable DASH protocol or not
 * @property download Enable Download protocol or not
 * @property hls Enable HLS protocol or not
 * @property smoothStreaming Enable SmoothStreaming protocol or not
 */
public data class EnabledProtocolsArgs(
    public val dash: Output<Boolean>,
    public val download: Output<Boolean>,
    public val hls: Output<Boolean>,
    public val smoothStreaming: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs =
        com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs.builder()
            .dash(dash.applyValue({ args0 -> args0 }))
            .download(download.applyValue({ args0 -> args0 }))
            .hls(hls.applyValue({ args0 -> args0 }))
            .smoothStreaming(smoothStreaming.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnabledProtocolsArgs].
 */
@PulumiTagMarker
public class EnabledProtocolsArgsBuilder internal constructor() {
    private var dash: Output<Boolean>? = null

    private var download: Output<Boolean>? = null

    private var hls: Output<Boolean>? = null

    private var smoothStreaming: Output<Boolean>? = null

    /**
     * @param value Enable DASH protocol or not
     */
    @JvmName("gipcujeecbncstuc")
    public suspend fun dash(`value`: Output<Boolean>) {
        this.dash = value
    }

    /**
     * @param value Enable Download protocol or not
     */
    @JvmName("cpotewgrvxgftaua")
    public suspend fun download(`value`: Output<Boolean>) {
        this.download = value
    }

    /**
     * @param value Enable HLS protocol or not
     */
    @JvmName("wehdusfuctfmuwdv")
    public suspend fun hls(`value`: Output<Boolean>) {
        this.hls = value
    }

    /**
     * @param value Enable SmoothStreaming protocol or not
     */
    @JvmName("rckvaxlovthpsndu")
    public suspend fun smoothStreaming(`value`: Output<Boolean>) {
        this.smoothStreaming = value
    }

    /**
     * @param value Enable DASH protocol or not
     */
    @JvmName("rcymymatmvypccha")
    public suspend fun dash(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dash = mapped
    }

    /**
     * @param value Enable Download protocol or not
     */
    @JvmName("wntqscmqmywgknvl")
    public suspend fun download(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.download = mapped
    }

    /**
     * @param value Enable HLS protocol or not
     */
    @JvmName("ybngsahwvtrosfxi")
    public suspend fun hls(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hls = mapped
    }

    /**
     * @param value Enable SmoothStreaming protocol or not
     */
    @JvmName("ruwcefbffiijpndf")
    public suspend fun smoothStreaming(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smoothStreaming = mapped
    }

    internal fun build(): EnabledProtocolsArgs = EnabledProtocolsArgs(
        dash = dash ?: throw PulumiNullFieldException("dash"),
        download = download ?: throw PulumiNullFieldException("download"),
        hls = hls ?: throw PulumiNullFieldException("hls"),
        smoothStreaming = smoothStreaming ?: throw PulumiNullFieldException("smoothStreaming"),
    )
}
