@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.FilterTrackPropertyConditionArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.FilterTrackPropertyCompareOperation
import com.pulumi.azurenative.media.kotlin.enums.FilterTrackPropertyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The class to specify one track property condition.
 * @property operation The track property condition operation.
 * @property property The track property type.
 * @property value The track property value.
 */
public data class FilterTrackPropertyConditionArgs(
    public val operation: Output<Either<String, FilterTrackPropertyCompareOperation>>,
    public val `property`: Output<Either<String, FilterTrackPropertyType>>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.FilterTrackPropertyConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.FilterTrackPropertyConditionArgs =
        com.pulumi.azurenative.media.inputs.FilterTrackPropertyConditionArgs.builder()
            .operation(
                operation.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`property`(
                `property`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FilterTrackPropertyConditionArgs].
 */
@PulumiTagMarker
public class FilterTrackPropertyConditionArgsBuilder internal constructor() {
    private var operation: Output<Either<String, FilterTrackPropertyCompareOperation>>? = null

    private var `property`: Output<Either<String, FilterTrackPropertyType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The track property condition operation.
     */
    @JvmName("ovfhhxcnekdngtul")
    public suspend
    fun operation(`value`: Output<Either<String, FilterTrackPropertyCompareOperation>>) {
        this.operation = value
    }

    /**
     * @param value The track property type.
     */
    @JvmName("adnlsbycnskikqfx")
    public suspend fun `property`(`value`: Output<Either<String, FilterTrackPropertyType>>) {
        this.`property` = value
    }

    /**
     * @param value The track property value.
     */
    @JvmName("tntlhiakorvslwox")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The track property condition operation.
     */
    @JvmName("wcrjodyrgonkrowh")
    public suspend fun operation(`value`: Either<String, FilterTrackPropertyCompareOperation>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value The track property condition operation.
     */
    @JvmName("toeuyaxsbbfxfmcg")
    public fun operation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FilterTrackPropertyCompareOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value The track property condition operation.
     */
    @JvmName("vqymsyjefjodaset")
    public fun operation(`value`: FilterTrackPropertyCompareOperation) {
        val toBeMapped = Either.ofRight<String, FilterTrackPropertyCompareOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value The track property type.
     */
    @JvmName("vohrrwqufiidcmrc")
    public suspend fun `property`(`value`: Either<String, FilterTrackPropertyType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`property` = mapped
    }

    /**
     * @param value The track property type.
     */
    @JvmName("dagatjcygjvduyyr")
    public fun `property`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FilterTrackPropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`property` = mapped
    }

    /**
     * @param value The track property type.
     */
    @JvmName("jhrgtpfwncpbbnhi")
    public fun `property`(`value`: FilterTrackPropertyType) {
        val toBeMapped = Either.ofRight<String, FilterTrackPropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`property` = mapped
    }

    /**
     * @param value The track property value.
     */
    @JvmName("qipaxurnekywogpf")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): FilterTrackPropertyConditionArgs = FilterTrackPropertyConditionArgs(
        operation = operation ?: throw PulumiNullFieldException("operation"),
        `property` = `property` ?: throw PulumiNullFieldException("property"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
