@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.FilterTrackSelectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.
 * @property trackSelections The track selections.
 */
public data class FilterTrackSelectionArgs(
    public val trackSelections: Output<List<FilterTrackPropertyConditionArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.FilterTrackSelectionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.FilterTrackSelectionArgs =
        com.pulumi.azurenative.media.inputs.FilterTrackSelectionArgs.builder()
            .trackSelections(
                trackSelections.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FilterTrackSelectionArgs].
 */
@PulumiTagMarker
public class FilterTrackSelectionArgsBuilder internal constructor() {
    private var trackSelections: Output<List<FilterTrackPropertyConditionArgs>>? = null

    /**
     * @param value The track selections.
     */
    @JvmName("kwauagwyqntsqslb")
    public suspend fun trackSelections(`value`: Output<List<FilterTrackPropertyConditionArgs>>) {
        this.trackSelections = value
    }

    @JvmName("jjfdibydootnuves")
    public suspend fun trackSelections(vararg values: Output<FilterTrackPropertyConditionArgs>) {
        this.trackSelections = Output.all(values.asList())
    }

    /**
     * @param values The track selections.
     */
    @JvmName("abtxkuilwixhxpuf")
    public suspend fun trackSelections(values: List<Output<FilterTrackPropertyConditionArgs>>) {
        this.trackSelections = Output.all(values)
    }

    /**
     * @param value The track selections.
     */
    @JvmName("ommbhajmigfihnll")
    public suspend fun trackSelections(`value`: List<FilterTrackPropertyConditionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trackSelections = mapped
    }

    /**
     * @param argument The track selections.
     */
    @JvmName("eqmklxavjxevftfm")
    public suspend
    fun trackSelections(argument: List<suspend FilterTrackPropertyConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilterTrackPropertyConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trackSelections = mapped
    }

    /**
     * @param argument The track selections.
     */
    @JvmName("ruagucryexcixncn")
    public suspend fun trackSelections(
        vararg
        argument: suspend FilterTrackPropertyConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FilterTrackPropertyConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trackSelections = mapped
    }

    /**
     * @param argument The track selections.
     */
    @JvmName("hcdkjudjxxxkgqnw")
    public suspend
    fun trackSelections(argument: suspend FilterTrackPropertyConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FilterTrackPropertyConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.trackSelections = mapped
    }

    /**
     * @param values The track selections.
     */
    @JvmName("ubuufhhoixoohylv")
    public suspend fun trackSelections(vararg values: FilterTrackPropertyConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trackSelections = mapped
    }

    internal fun build(): FilterTrackSelectionArgs = FilterTrackSelectionArgs(
        trackSelections = trackSelections ?: throw PulumiNullFieldException("trackSelections"),
    )
}
