@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.FirstQualityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Filter First Quality
 * @property bitrate The first quality bitrate.
 */
public data class FirstQualityArgs(
    public val bitrate: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.FirstQualityArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.FirstQualityArgs =
        com.pulumi.azurenative.media.inputs.FirstQualityArgs.builder()
            .bitrate(bitrate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirstQualityArgs].
 */
@PulumiTagMarker
public class FirstQualityArgsBuilder internal constructor() {
    private var bitrate: Output<Int>? = null

    /**
     * @param value The first quality bitrate.
     */
    @JvmName("ufjlwuvjjnyifmbn")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value The first quality bitrate.
     */
    @JvmName("eiyxxltyydaxmovs")
    public suspend fun bitrate(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    internal fun build(): FirstQualityArgs = FirstQualityArgs(
        bitrate = bitrate ?: throw PulumiNullFieldException("bitrate"),
    )
}
