@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.FromAllInputFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An InputDefinition that looks across all of the files provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to allow selection of a single track across a set of input files.
 * @property includedTracks The list of TrackDescriptors which define the metadata and selection of tracks in the input.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.FromAllInputFile'.
 */
public data class FromAllInputFileArgs(
    public val includedTracks: Output<List<Any>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.FromAllInputFileArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.FromAllInputFileArgs =
        com.pulumi.azurenative.media.inputs.FromAllInputFileArgs.builder()
            .includedTracks(includedTracks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FromAllInputFileArgs].
 */
@PulumiTagMarker
public class FromAllInputFileArgsBuilder internal constructor() {
    private var includedTracks: Output<List<Any>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("buaomqaqndoyniaq")
    public suspend fun includedTracks(`value`: Output<List<Any>>) {
        this.includedTracks = value
    }

    @JvmName("nlnakwpwxbucothh")
    public suspend fun includedTracks(vararg values: Output<Any>) {
        this.includedTracks = Output.all(values.asList())
    }

    /**
     * @param values The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("vfgnnedlubtmtyvy")
    public suspend fun includedTracks(values: List<Output<Any>>) {
        this.includedTracks = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.FromAllInputFile'.
     */
    @JvmName("tcvjhqoecgsqvxtv")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("smqpslfifbpaeupf")
    public suspend fun includedTracks(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedTracks = mapped
    }

    /**
     * @param values The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("dqotsqfrykqrdnky")
    public suspend fun includedTracks(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedTracks = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.FromAllInputFile'.
     */
    @JvmName("omdeqsaipasoywta")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): FromAllInputFileArgs = FromAllInputFileArgs(
        includedTracks = includedTracks,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
