@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.FromEachInputFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select tracks from each file given.
 * @property includedTracks The list of TrackDescriptors which define the metadata and selection of tracks in the input.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.FromEachInputFile'.
 */
public data class FromEachInputFileArgs(
    public val includedTracks: Output<List<Any>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.FromEachInputFileArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.FromEachInputFileArgs =
        com.pulumi.azurenative.media.inputs.FromEachInputFileArgs.builder()
            .includedTracks(includedTracks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FromEachInputFileArgs].
 */
@PulumiTagMarker
public class FromEachInputFileArgsBuilder internal constructor() {
    private var includedTracks: Output<List<Any>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("xebgtqjpqwrsmjrr")
    public suspend fun includedTracks(`value`: Output<List<Any>>) {
        this.includedTracks = value
    }

    @JvmName("oqglbfasdrwajdmr")
    public suspend fun includedTracks(vararg values: Output<Any>) {
        this.includedTracks = Output.all(values.asList())
    }

    /**
     * @param values The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("kuowhvcacdbnyaoy")
    public suspend fun includedTracks(values: List<Output<Any>>) {
        this.includedTracks = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.FromEachInputFile'.
     */
    @JvmName("hwxaifbxkcaqmrkw")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("lyaysechcxcjbigf")
    public suspend fun includedTracks(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedTracks = mapped
    }

    /**
     * @param values The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("ppgrglnwllpupgrl")
    public suspend fun includedTracks(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedTracks = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.FromEachInputFile'.
     */
    @JvmName("shjisqugvlfbqgmj")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): FromEachInputFileArgs = FromEachInputFileArgs(
        includedTracks = includedTracks,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
